% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_p_frac.R
\name{lsm_p_frac}
\alias{lsm_p_frac}
\alias{lsm_p_frac.RasterLayer}
\alias{lsm_p_frac.RasterStack}
\alias{lsm_p_frac.RasterBrick}
\alias{lsm_p_frac.list}
\title{FRAC (patch level)}
\usage{
lsm_p_frac(landscape, directions)

\method{lsm_p_frac}{RasterLayer}(landscape, directions = 8)

\method{lsm_p_frac}{RasterStack}(landscape, directions = 8)

\method{lsm_p_frac}{RasterBrick}(landscape, directions = 8)

\method{lsm_p_frac}{list}(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Fractal dimension index (Shape metric)
}
\details{
\deqn{FRAC = \frac{2 * \ln * (0.25 * p_{ij})} {\ln a_{ij}}}
where \eqn{p_{ij}} is the perimeter in meters and \eqn{a_{ij}} is the
area in square meters

FRAC is a 'Shape metric'. The index is based on the patch perimeter and
the patch area and describes the patch complexity. Because it is standardized,
it is scale independent, meaning that increasing the patch size while not changing the
patch form will not change the ratio.

\subsection{Units}{None}
\subsection{Range}{1 <= FRAC <= 2 }
\subsection{Behaviour}{Approaches FRAC = 1 for a squared patch shape form and FRAC = 2
for a irregular patch shape.}
}
\examples{
lsm_p_frac(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html

Mandelbrot, B. B. 1977. Fractals: Form, Chance, and Dimension.
San Francisco. W. H. Freeman and Company.
}
\seealso{
\code{\link{lsm_p_area}},
\code{\link{lsm_p_perim}}, \cr
\code{\link{lsm_c_frac_mn}},
\code{\link{lsm_c_frac_sd}},
\code{\link{lsm_c_frac_cv}}, \cr
\code{\link{lsm_l_frac_mn}},
\code{\link{lsm_l_frac_sd}},
\code{\link{lsm_l_frac_cv}}
}
