% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_p_area.R
\name{lsm_p_area}
\alias{lsm_p_area}
\alias{lsm_p_area.RasterLayer}
\alias{lsm_p_area.RasterStack}
\alias{lsm_p_area.RasterBrick}
\alias{lsm_p_area.stars}
\alias{lsm_p_area.list}
\title{AREA (patch level)}
\usage{
lsm_p_area(landscape, directions)

\method{lsm_p_area}{RasterLayer}(landscape, directions = 8)

\method{lsm_p_area}{RasterStack}(landscape, directions = 8)

\method{lsm_p_area}{RasterBrick}(landscape, directions = 8)

\method{lsm_p_area}{stars}(landscape, directions = 8)

\method{lsm_p_area}{list}(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Patch area (Area and edge metric)
}
\details{
\deqn{AREA = a_{ij} * (\frac{1} {10000})}
where \eqn{a_{ij}} is the area in square meters.

AREA is an 'Area and edge metric' and equals the area of each patch in hectares.
The lower limit of AREA is limited by the resolution of the input raster,
i.e. AREA can't be smaller than the resolution squared (in hectares). It is one of
the most basic, but also most important metrics, to characterise a landscape. The
metric is the simplest measure of composition.

\subsection{Units}{Hectares}
\subsection{Range}{AREA > 0}
\subsection{Behaviour}{Increases, without limit, as the patch size increases.}
}
\examples{
lsm_p_area(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html
}
\seealso{
\code{\link{lsm_c_area_mn}},
\code{\link{lsm_c_area_sd}},
\code{\link{lsm_c_area_cv}},
\code{\link{lsm_c_ca}}, \cr
\code{\link{lsm_l_area_mn}},
\code{\link{lsm_l_area_sd}},
\code{\link{lsm_l_area_cv}},
\code{\link{lsm_l_ta}}
}
