% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_shape_sd.R
\name{lsm_l_shape_sd}
\alias{lsm_l_shape_sd}
\title{SHAPE_SD (landscape level)}
\usage{
lsm_l_shape_sd(landscape, directions = 8)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Standard deviation shape index (Shape metric)
}
\details{
\deqn{SHAPE_{SD} = sd(SHAPE[patch_{ij}])}
where \eqn{SHAPE[patch_{ij}]} is the shape index of each patch.

SHAPE_SD is a 'Shape metric'. The landscape summarised as the standard deviation
of all patches in the landscape. SHAPE describes the ratio between the actual perimeter of
the patch and the square root of patch area.

\subsection{Units}{None}
\subsection{Range}{SHAPE_SD >= 0}
\subsection{Behaviour}{Equals SHAPE_SD = 0 if all patches have an identical shape index.
Increases, without limit, as the variation of the shape index increases.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_l_shape_sd(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org

Patton, D. R. 1975. A diversity index for quantifying habitat "edge".
Wildl. Soc.Bull. 3:171-173.
}
\seealso{
\code{\link{lsm_p_shape}},
\code{\link{sd}}, \cr
\code{\link{lsm_c_shape_mn}},
\code{\link{lsm_c_shape_sd}},
\code{\link{lsm_c_shape_cv}}, \cr
\code{\link{lsm_l_shape_mn}},
\code{\link{lsm_l_shape_cv}}
}
