% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-LandsepiParams.R
\name{survivalProbToMatrix}
\alias{survivalProbToMatrix}
\title{Survival probability To Matrix}
\usage{
survivalProbToMatrix(params)
}
\arguments{
\item{params}{a LandsepiParams object.}
}
\value{
a list containing a matrix of dimensions (Nyears, Ncroptypes) as well as a matrix of
dimensions (Npoly, Nyears)
}
\description{
Transform the off-season survival probability of the pathogen
(1D vector of length Nyears*Ncroptypes) into a matrix (for visualization purpose)
}
\details{
After updating the off-season survival probability with \code{updateSurvivalProb()},
this function returns the probability as a matrix for every year (rows) and croptypes (columns)
as well as, if croptypes have been previously allocated to a landscape, a matrix for every
polygon (rows) and year (columns).
}
\examples{
\dontrun{
simul_params <- createSimulParams()
simul_params <- setTime(simul_params, Nyears=10, nTSpY=120)
simul_params <- setPathogen(simul_params, loadPathogen("rust"))

cultivar1 <- loadCultivar(name = "Susceptible", type = "growingHost")
cultivar2 <- loadCultivar(name = "Resistant", type = "growingHost")
cultivars <- data.frame(rbind(cultivar1, cultivar2), stringsAsFactors = FALSE)
simul_params <- setCultivars(simul_params, cultivars)

croptypes <- loadCroptypes(simul_params
, names = c("Susceptible crop", "Resistant crop", "Mixture"))
croptypes <- allocateCroptypeCultivars(croptypes, "Susceptible crop", "Susceptible")
croptypes <- allocateCroptypeCultivars(croptypes, "Resistant crop", "Resistant")
croptypes <- allocateCroptypeCultivars(croptypes, "Mixture", c("Susceptible", "Resistant"))
simul_params <- setCroptypes(simul_params, croptypes)

Ncroptypes <- nrow(simul_params@Croptypes)
Nyears <- simul_params@TimeParam$Nyears

landscape <- loadLandscape(1)
simul_params <- setLandscape(simul_params, landscape)
simul_params <- allocateLandscapeCroptypes(simul_params,
rotation_period = 0, rotation_sequence = croptypes$croptypeID,
rotation_realloc = FALSE,
prop = rep(1/Ncroptypes, Ncroptypes),
aggreg = 0.05, graphic = FALSE)

## One probability per year and per croptype:
simul_params <- updateSurvivalProb(simul_params
, mat=matrix(runif(Nyears*Ncroptypes), ncol=Ncroptypes))
simul_params@Pathogen
survivalProbToMatrix(simul_params)
}
}
\seealso{
\link{updateSurvivalProb}
}
