% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrabble.R
\name{scrabble_score}
\alias{scrabble_score}
\title{Scrabble: Word Scores}
\usage{
scrabble_score(words, scores)
}
\arguments{
\item{words}{Character vector. Words to score}

\item{scores}{Dataframe. Must contain two columns: "tiles" with every
letter of the alphabet and "scores" for each letter's score.}
}
\value{
data.frame with word, scores, and length values for each \code{word}.
}
\description{
Get score for any word or list of words. You may set manually depending
on the rules and languages you are playing with. Check the examples
for Spanish and English values when I played Words With Friends.
}
\examples{
\donttest{
# For Spanish words (default)
es_scores <- scrabble_points("es")
# Custom scores for each letter
cu_scores <- data.frame(
  tiles = tolower(LETTERS),
  scores = c(1, 1, 1, 1, 1, 1, 1, 5, 1, 1, 5, 2, 4, 2, 1, 4, 10, 1, 1, 1, 2, 5, 4, 8, 3, 10)
)

# Score values for each set of rules
words <- c("Bernardo", "Whiskey", "R is great")
scrabble_score(words, es_scores)
scrabble_score(words, cu_scores)
}
}
\seealso{
Other Scrabble: 
\code{\link{scrabble_dictionary}()},
\code{\link{scrabble_points}()},
\code{\link{scrabble_words}()}
}
\concept{Scrabble}
