% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stocks.R
\name{stocks_report}
\alias{stocks_report}
\title{Portfolio's Full Report and Email}
\usage{
stocks_report(
  data = NA,
  keep_old = TRUE,
  dir = NA,
  mail = FALSE,
  attachment = TRUE,
  to = "laresbernardo@gmail.com",
  sectors = FALSE,
  keep = FALSE,
  creds = NA,
  cache = TRUE
)
}
\arguments{
\item{data}{Character. \code{stocks_obj()} output. If NA, automatic
parameters and \code{stocks_file()} defaults will be used.}

\item{keep_old}{Boolean. Include sold tickers even though not currently in portfolio?}

\item{dir}{Character. Directory for HTML report output. If set to NA,
current working directory will be used. If mail sent, file will be erased}

\item{mail}{Boolean. Do you want to send an email with the report attached?
If not, an HTML file will be created in dir}

\item{attachment}{Boolean. Create and add report as attachment if
\code{mail=TRUE}? If not, no report will be rendered and only tabulated
summaries will be included on email's body.}

\item{to}{Character. Email to send the report to}

\item{sectors}{Boolean. Return sectors segmentation for ETFs?}

\item{keep}{Boolean. Keep HTML file when sent by email?}

\item{creds}{Character. Credential's user (see \code{get_creds()}) for
sending mail and Dropbox interaction.}

\item{cache}{Boolean. Use daily cache if available?}
}
\value{
Invisible list. Aggregated results and plots.
}
\description{
This function lets the user create his portfolio's full report with
plots and send it to an email with the HTML report attached
}
\examples{
\dontrun{
list <- stocks_obj()
stocks_report(list, dir = "~/Desktop")
}
}
\seealso{
Other Investment: 
\code{\link{daily_portfolio}()},
\code{\link{daily_stocks}()},
\code{\link{etf_sector}()},
\code{\link{splot_change}()},
\code{\link{splot_etf}()},
\code{\link{splot_growth}()},
\code{\link{splot_roi}()},
\code{\link{splot_summary}()},
\code{\link{splot_types}()},
\code{\link{stocks_file}()},
\code{\link{stocks_hist}()},
\code{\link{stocks_obj}()},
\code{\link{stocks_quote}()}

Other Credentials: 
\code{\link{db_download}()},
\code{\link{db_upload}()},
\code{\link{get_credentials}()},
\code{\link{get_tweets}()},
\code{\link{mailSend}()},
\code{\link{queryDB}()},
\code{\link{queryGA}()},
\code{\link{slackSend}()},
\code{\link{stocks_file}()}
}
\concept{Credentials}
\concept{Investment}
