% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_functions.R
\name{replacefactor}
\alias{replacefactor}
\title{Replace Factor Values}
\usage{
replacefactor(x, original, change)
}
\arguments{
\item{x}{Factor (or Character) Vector}

\item{original}{String or Vector. Original text you wish to replace}

\item{change}{String or Vector. Values you wish to replace the originals with}
}
\value{
Factor vector with transformed levels.
}
\description{
This function lets the user replace levels on a factor vector.
}
\examples{
library(dplyr)
data(dft)
# Replace a single value
dft <- mutate(dft, Pclass = replacefactor(Pclass, original = "1", change = "First"))
levels(dft$Pclass)
# Replace multiple values
dft <- mutate(dft, Pclass = replacefactor(Pclass, c("2", "3"), c("Second", "Third")))
levels(dft$Pclass)
}
