% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence.R
\name{ci_lower}
\alias{ci_lower}
\alias{ci_upper}
\title{Lower/Upper Confidence Intervals}
\usage{
ci_lower(mean, ssd, n, conf = 0.95)

ci_upper(mean, ssd, n, conf = 0.95)
}
\arguments{
\item{mean}{Numeric. Mean: \code{mean(var, na.rm = TRUE)}}

\item{ssd}{Numeric. Standard deviation: \code{sd(var, na.rm = TRUE)}}

\item{n}{Integer. Amount of observations: \code{n()}}

\item{conf}{Numeric (0-1). Confidence level.}
}
\value{
Vector with confidence limit value.
}
\description{
Calculate lower and upper confidence intervals given a mean,
standard deviation, sample size, and confidence level. You may
want to use \code{ci_var()} to calculate all values quickly.
}
\examples{
ci_lower(100, 5, 10)
ci_upper(100, 5, 10)
}
\seealso{
Other Confidence: 
\code{\link{ci_var}()}
}
\concept{Confidence}
