% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_functions.R
\name{listfiles}
\alias{listfiles}
\title{List files in a directory}
\usage{
listfiles(folder = getwd(), recursive = TRUE, regex = NA, images = FALSE)
}
\arguments{
\item{folder}{Character. Directory which contains files}

\item{recursive}{Boolean. Should the listing recurse into directories?}

\item{regex}{Character. String to use for filtering files}

\item{images}{Boolean. Bring only image files?}
}
\value{
data.frame with relevant data for each file on
\code{folder} directory.
}
\description{
This function lets the user list all files on a given directory.
It also lets filter files which contains a string.
}
\examples{
# All files in current directory (without recursive files)
df <- listfiles(recursive = TRUE)
head(df, 3)

# All files in current directory (with recursive files)
df <- listfiles(recursive = TRUE)
tail(df, 3)

# Check R files using regex
df <- listfiles(regex = "\\\\.R$")
}
\seealso{
Other Tools: 
\code{\link{autoline}()},
\code{\link{bind_files}()},
\code{\link{bring_api}()},
\code{\link{db_download}()},
\code{\link{db_upload}()},
\code{\link{export_plot}()},
\code{\link{export_results}()},
\code{\link{files_functions}()},
\code{\link{font_exists}()},
\code{\link{formatColoured}()},
\code{\link{formatHTML}()},
\code{\link{get_credentials}()},
\code{\link{glued}()},
\code{\link{grepm}()},
\code{\link{h2o_selectmodel}()},
\code{\link{haveInternet}()},
\code{\link{image_metadata}()},
\code{\link{importxlsx}()},
\code{\link{ip_data}()},
\code{\link{json2vector}()},
\code{\link{list_cats}()},
\code{\link{mail_send}()},
\code{\link{markdown2df}()},
\code{\link{move_files}()},
\code{\link{msplit}()},
\code{\link{myip}()},
\code{\link{quiet}()},
\code{\link{read.file}()},
\code{\link{statusbar}()},
\code{\link{tic}()},
\code{\link{try_require}()},
\code{\link{updateLares}()},
\code{\link{warnifnot}()},
\code{\link{what_size}()}
}
\concept{Tools}
