% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ltable.R
\name{as.ltable}
\alias{as.ltable}
\alias{as.ltable.data.frame}
\alias{as.ltable.table}
\alias{as.ltable.matrix}
\title{Coerce to LaTeX Table Environment}
\usage{
as.ltable(x, ...)

\method{as.ltable}{data.frame}(
  x,
  caption = NULL,
  cap = caption,
  cap.top = TRUE,
  label = NULL,
  options = "H",
  environments = "center",
  source = NULL,
  file = NULL,
  source.label = "source: ",
  file.label = "file: ",
  basefile = FALSE,
  footnote.size = "tiny",
  ...
)

\method{as.ltable}{table}(x, ...)

\method{as.ltable}{matrix}(x, caption = names(dimnames(x))[[2]], ...)
}
\arguments{
\item{x}{object}

\item{...}{passed arguments}

\item{caption}{full version of the caption}

\item{cap}{short version of the caption, for list of tables}

\item{cap.top}{Should caption be placed at the top, instead of bottom?}

\item{label}{optional label}

\item{options}{options for latex table environment, e.g. H or !htpb}

\item{environments}{extra environments to nest between \sQuote{table} and \sQuote{tabular}}

\item{source}{optional source attribution}

\item{file}{optional file name}

\item{source.label}{optional text to preceed source if specified}

\item{file.label}{optional text to preceed file if specified}

\item{basefile}{if TRUE, strip path from file for display purposes}

\item{footnote.size}{font size for source and file, etc.}
}
\value{
character
}
\description{
Coerces to LaTeX table environment.  Generic, with methods for data.frame, table, and matrix.

Coerces to LaTeX table from data.frame. See details.

Coerces to ltable from table, reclassifying its argument as matrix.

Coerces to ltable from matrix; tires to capture the column names as a caption, and (like \code{as.tabular.matrix}) converts its argument to data.frame, capturing rownames as a column in the first position if rownames are suitably named.
}
\details{
Converts data.frame to tabular, then wraps it in specified environments, then wraps result in a latex table environment.  Result is returned visibly, or if \code{file} is specified it is printed to file and returned invisibly.
If \code{source} and \code{source.label} are defined, they will be printed in a tiny font immediately under the table (bound to the tabular element).  If \code{file} and \code{file.label} are defined as well, they will be printed (tiny) under source.  Set \code{source.label} to NULL to suppress embedding of \code{source}; set to empty string to suppress source label. Set \code{file.label} to NULL to suppress embedding of \code{file}; set to empty string to suppress file label. Note that \code{file} controls file destination, whether or not represented in the result.

Extra arguments(\dots) are passed to \code{\link{as.tabular}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{data.frame}: data.frame method

\item \code{table}: table method

\item \code{matrix}: matrix method
}}

\examples{
as.ltable(head(Theoph))
as.ltable(table(1:3,4:6))
}
\seealso{
\code{\link{as.tabular}}

\code{\link{as.tabular}}
}
