% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latrend.R
\name{latrendBatch}
\alias{latrendBatch}
\title{Cluster longitudinal data for a list of model specifications}
\usage{
latrendBatch(
  methods,
  data,
  cartesian = TRUE,
  envir = NULL,
  verbose = getOption("latrend.verbose")
)
}
\arguments{
\item{methods}{A \code{list} of \code{lcMethod} objects.}

\item{data}{A \code{data.frame}, \code{matrix}, or a \code{list} thereof to which to apply to the respective \code{lcMethod}. Multiple datasets can be supplied by encapsulating the datasets using \code{data=.(df1, df2, ..., dfN)}.}

\item{cartesian}{Whether to fit the provided methods on each of the datasets. If \code{cartesian=FALSE}, only a single dataset may be provided or a list of data matching the length of \code{methods}.}

\item{envir}{The \code{environment} in which to evaluate the \code{lcMethod} arguments.}

\item{verbose}{The level of verbosity. Either an object of class \code{Verbose} (see \link[R.utils:Verbose]{R.utils::Verbose} for details),
a \code{logical} indicating whether to show basic computation information,
a \code{numeric} indicating the verbosity level (see \link{Verbose}),
or one of \code{c('info', 'fine', 'finest')}.}
}
\value{
A \code{lcModels} object.
}
\description{
Fit a list of longitudinal cluster methods.
}
\examples{
data(latrendData)
methods <- lcMethods(lcMethodKML("Y", id = "Id", time = "Time"), nClusters = 1:3)
models <- latrendBatch(methods, data = latrendData)

models <- latrendBatch(lcMethods(lcMethodKML("Y", id = "Id", time = "Time"), nClusters = 1:2),
   data = .(subset(latrendData, Time > .5),
            subset(latrendData, Time < .5))) # different data per method

}
\seealso{
lcMethods

Other longitudinal cluster fit functions: 
\code{\link{latrendBoot}()},
\code{\link{latrendCV}()},
\code{\link{latrendRep}()},
\code{\link{latrend}()}
}
\concept{longitudinal cluster fit functions}
