% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodMixtoolsGMM.R, R/methodMixtoolsNPRM.R,
%   R/modelMixtoolsGMM.R, R/modelMixtoolsRM.R
\name{interface-mixtools}
\alias{interface-mixtools}
\alias{getName,lcMethodMixtoolsGMM-method}
\alias{getShortName,lcMethodMixtoolsGMM-method}
\alias{preFit,lcMethodMixtoolsGMM-method}
\alias{fit,lcMethodMixtoolsGMM-method}
\alias{getName,lcMethodMixtoolsNPRM-method}
\alias{getShortName,lcMethodMixtoolsNPRM-method}
\alias{fit,lcMethodMixtoolsNPRM-method}
\alias{predictForCluster,lcModelMixtoolsGMM-method}
\alias{postprob,lcModelMixtoolsGMM-method}
\alias{logLik.lcModelMixtoolsGMM}
\alias{coef.lcModelMixtoolsGMM}
\alias{sigma.lcModelMixtoolsGMM}
\alias{clusterTrajectories,lcModelMixtoolsRM-method}
\alias{postprob,lcModelMixtoolsRM-method}
\alias{logLik.lcModelMixtoolsRM}
\alias{converged,lcModelMixtoolsRM-method}
\title{mixtools interface}
\usage{
\S4method{getName}{lcMethodMixtoolsGMM}(object)

\S4method{getShortName}{lcMethodMixtoolsGMM}(object)

\S4method{preFit}{lcMethodMixtoolsGMM}(method, data, envir, verbose, ...)

\S4method{fit}{lcMethodMixtoolsGMM}(method, data, envir, verbose, ...)

\S4method{getName}{lcMethodMixtoolsNPRM}(object)

\S4method{getShortName}{lcMethodMixtoolsNPRM}(object)

\S4method{fit}{lcMethodMixtoolsNPRM}(method, data, envir, verbose, ...)

\S4method{predictForCluster}{lcModelMixtoolsGMM}(object, newdata, cluster, what = "mu", ...)

\S4method{postprob}{lcModelMixtoolsGMM}(object, ...)

\method{logLik}{lcModelMixtoolsGMM}(object, ...)

\method{coef}{lcModelMixtoolsGMM}(object, ...)

\method{sigma}{lcModelMixtoolsGMM}(object, ...)

\S4method{clusterTrajectories}{lcModelMixtoolsRM}(
  object,
  at = time(object),
  what = "mu",
  se = TRUE,
  ci = c(0.025, 0.975),
  ...
)

\S4method{postprob}{lcModelMixtoolsRM}(object, ...)

\method{logLik}{lcModelMixtoolsRM}(object, ...)

\S4method{converged}{lcModelMixtoolsRM}(object, ...)
}
\arguments{
\item{object}{The object to extract the label from.}

\item{method}{The \code{lcMethod} object.}

\item{data}{The data, as a \code{data.frame}, on which the model will be trained.}

\item{envir}{The \code{environment} in which the \code{lcMethod} should be evaluated}

\item{verbose}{A \link[R.utils:Verbose]{R.utils::Verbose} object indicating the level of verbosity.}

\item{...}{Additional arguments.}

\item{newdata}{Optional \code{data.frame} for which to compute the model predictions. If omitted, the model training data is used.
Cluster trajectory predictions are made when ids are not specified.}

\item{cluster}{The cluster name (as \code{character}) to predict for.}

\item{what}{The distributional parameter to predict. By default, the mean response 'mu' is predicted. The cluster membership predictions can be obtained by specifying \code{what = 'mb'}.}

\item{at}{An optional vector, list or data frame of covariates at which to compute the cluster trajectory predictions.
If a vector is specified, this is assumed to be the time covariate. Otherwise, a named list or data frame must be provided.}

\item{se}{Whether to compute the standard error of the prediction.}

\item{ci}{The confidence interval to compute.}
}
\description{
mixtools interface
}
\seealso{
\link{lcMethodMixtoolsGMM} \link{lcMethodMixtoolsNPRM} \link[mixtools]{regmixEM.mixed} \link[mixtools]{npEM}
}
\keyword{internal}
