% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodMixTVEM.R
\name{lcMethodMixTVEM}
\alias{lcMethodMixTVEM}
\title{Specify a MixTVEM}
\usage{
lcMethodMixTVEM(
  formula,
  formula.mb = ~1,
  time = getOption("latrend.time"),
  id = getOption("latrend.id"),
  nClusters = 2,
  ...
)
}
\arguments{
\item{formula}{A \code{formula} excluding the time component. Time-invariant covariates are detected automatically as these are a special case in MixTVEM.}

\item{formula.mb}{A \code{formula} for cluster-membership prediction. Covariates must be time-invariant. Furthermore, the formula must contain an intercept.}

\item{time}{The name of the time variable.}

\item{id}{The name of the trajectory identifier variable.}

\item{nClusters}{The number of clusters. This replaces the \code{numClasses} argument of the \code{TVEMMixNormal} function call.}

\item{...}{Arguments passed to the \code{TVEMMixNormal()} function.
The following optional arguments are ignored: doPlot, getSEs, numClasses.}
}
\description{
Specify a MixTVEM
}
\note{
In order to use this method, you must download and source MixTVEM.R. See the reference below.
}
\examples{
\donttest{
# this example only runs if you download and place MixTVEM.R in your wd
try({
  source('MixTVEM.R')
  method = lcMethodMixTVEM(Value ~ time(1) - 1,
                     time='Assessment',
                     id='Id', nClusters=3)
})
}
}
\references{
\url{https://github.com/dziakj1/MixTVEM}

\insertRef{dziak2015modeling}{latrend}
}
