% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{getArgumentExclusions}
\alias{getArgumentExclusions}
\alias{getArgumentExclusions,lcMethod-method}
\title{Arguments to be excluded for lcMethod subclass}
\usage{
\S4method{getArgumentExclusions}{lcMethod}(object)
}
\arguments{
\item{object}{The \code{lcMethod} object.}
}
\value{
A \code{character} vector of argument names.
}
\description{
Returns the names of arguments that should be excluded during instantiation of the \code{lcMethod}.
}
\section{Implementation}{

This function only needs to be implemented if you want to avoid users from specifying
redundant arguments or arguments that are set automatically or conditionally on other arguments.

\preformatted{
setMethod("getArgumentExclusions", "lcMethodExample", function(object) {
  c(
    "doPlot",
    "verbose",
    callNextMethod()
  )
})

Adding `callNextMethod()` to the end of the return vector enables inheriting exclusions from superclasses.
}
}

\seealso{
\link{lcMethod} \link{getArgumentExclusions}

Other lcMethod implementations: 
\code{\link{getArgumentDefaults}()},
\code{\link{lcMethod-class}},
\code{\link{lcMethodAkmedoids}},
\code{\link{lcMethodCrimCV}},
\code{\link{lcMethodCustom}},
\code{\link{lcMethodDtwclust}},
\code{\link{lcMethodFeature}},
\code{\link{lcMethodFunFEM}},
\code{\link{lcMethodGCKM}},
\code{\link{lcMethodKML}},
\code{\link{lcMethodLMKM}},
\code{\link{lcMethodLcmmGBTM}},
\code{\link{lcMethodLcmmGMM}},
\code{\link{lcMethodMclustLLPA}},
\code{\link{lcMethodMixAK_GLMM}},
\code{\link{lcMethodMixtoolsGMM}},
\code{\link{lcMethodMixtoolsNPRM}},
\code{\link{lcMethodRandom}},
\code{\link{lcMethodStratify}}
}
\concept{lcMethod implementations}
