% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{getCall.lcModel}
\alias{getCall.lcModel}
\title{Get the model call}
\usage{
\method{getCall}{lcModel}(x, ...)
}
\arguments{
\item{x}{The \code{lcModel} object.}

\item{...}{Not used.}
}
\value{
A \code{call} to \code{\link[=latrend]{latrend()}} with the necessary arguments and data.
}
\description{
Extract the \code{call} that was used to fit the given \code{lcModel} object.
}
\examples{
data(latrendData)
method <- lcMethodRandom("Y", id = "Id", time = "Time")
model <- latrend(method, latrendData)
getCall(model)
}
\seealso{
\link[stats:update]{stats::getCall} \link{getLcMethod}
}
\keyword{internal}
