% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{residuals.lcModel}
\alias{residuals.lcModel}
\title{Extract lcModel residuals}
\usage{
\method{residuals}{lcModel}(object, ..., clusters = trajectoryAssignments(object))
}
\arguments{
\item{object}{The \code{lcModel} object.}

\item{...}{Additional arguments.}

\item{clusters}{Optional cluster assignments per id. If unspecified, a \code{matrix} is returned containing the cluster-specific predictions per column.}
}
\value{
A \verb{numeric vector} of residuals for the cluster assignments specified by clusters.
If the \code{clusters} argument is unspecified, a \code{matrix} of cluster-specific residuals per observations is returned.
}
\description{
Extract the residuals for a fitted \code{lcModel} object.
By default, residuals are computed under the most likely cluster assignment for each trajectory.
}
\seealso{
\link{fitted.lcModel} \link{trajectories}

Other model-specific methods: 
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{fitted.lcModel}()},
\code{\link{fittedTrajectories}()},
\code{\link{lcModel-class}},
\code{\link{logLik.lcModel}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nobs.lcModel}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictForCluster}()},
\code{\link{predictPostprob}()},
\code{\link{sigma.lcModel}()},
\code{\link{time.lcModel}()}
}
\concept{model-specific methods}
