% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-evaluation.R
\name{confusionMatrix}
\alias{confusionMatrix}
\title{Compute the posterior confusion matrix}
\usage{
confusionMatrix(object, strategy = which.max, scale = TRUE, ...)
}
\arguments{
\item{object}{The model, of type \code{lcModel}.}

\item{strategy}{The strategy for assigning trajectories to a specific cluster, see \code{\link[=trajectoryAssignments]{trajectoryAssignments()}}.
If \code{strategy = NULL}, the posterior probabilities are used as weights (analogous to a repeated evaluation of \code{strategy = which.weight}).}

\item{scale}{Whether to express the confusion in probabilities (\code{scale = TRUE}), or in terms of the number of trajectories.}

\item{...}{
  Arguments passed on to \code{\link[=trajectoryAssignments]{trajectoryAssignments}}
  \describe{
    \item{\code{}}{}
  }}
}
\value{
A K-by-K confusion \code{matrix} with \code{K = nClusters(object)}.
}
\description{
Compute the posterior confusion matrix (PCM).
The entry \eqn{(i,j)} represents the probability (or number, in case of  \code{scale = TRUE}) of a trajectory
belonging to cluster \eqn{i} is assigned to cluster \eqn{j} under the specified trajectory cluster assignment strategy.
}
\examples{
data(latrendData)

if (rlang::is_installed("lcmm")) {
  method <- lcMethodLcmmGMM(
    fixed = Y ~ Time,
    mixture = ~ Time,
    random = ~ 1,
    id = "Id",
    time = "Time"
  )
  model <- latrend(method, latrendData)
  confusionMatrix(model)
}
}
\seealso{
\link{postprob} \link{clusterProportions} \link{trajectoryAssignments} \link{APPA} \link{OCC}
}
