% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{predictAssignments}
\alias{predictAssignments}
\alias{predictAssignments,lcModel-method}
\title{Predict the cluster assignments for new trajectories}
\usage{
\S4method{predictAssignments}{lcModel}(object, newdata = NULL, strategy = which.max, ...)
}
\arguments{
\item{object}{The \code{lcModel} object.}

\item{newdata}{Optional \code{data.frame} for which to compute the model predictions. If omitted, the model training data is used.
Cluster trajectory predictions are made when ids are not specified.}

\item{strategy}{A function returning the cluster index based on the given \code{vector} of membership probabilities.
By default (\code{strategy = which.max}), trajectories are assigned to the most likely cluster.}

\item{...}{Additional arguments.}
}
\value{
A \code{factor} of length \code{nrow(newdata)} that indicates the assigned cluster per trajectory per observation.
}
\description{
Computes the posterior probability based on the provided (observed) data.
}
\details{
The default implementation uses \link{predictPostprob} to determine the cluster membership.
}
\examples{
\dontrun{
data(latrendData)
if (require("kml")) {
  model <- latrend(method = lcMethodKML("Y", id = "Id", time = "Time"), latrendData)
  predictAssignments(model, newdata = data.frame(Id = 999, Y = 0, Time = 0))
}
}
}
\seealso{
\link{predictPostprob} \link{predict.lcModel}

Other lcModel functions: 
\code{\link{clusterNames}()},
\code{\link{clusterProportions}()},
\code{\link{clusterSizes}()},
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{estimationTime}()},
\code{\link{externalMetric,lcModel,lcModel-method}},
\code{\link{fitted.lcModel}()},
\code{\link{fittedTrajectories}()},
\code{\link{getCall.lcModel}()},
\code{\link{getLcMethod}()},
\code{\link{ids}()},
\code{\link{lcModel-class}},
\code{\link{metric}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nClusters}()},
\code{\link{nIds}()},
\code{\link{nobs.lcModel}()},
\code{\link{plot-lcModel-method}},
\code{\link{plotClusterTrajectories}()},
\code{\link{plotFittedTrajectories}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictForCluster}()},
\code{\link{predictPostprob}()},
\code{\link{qqPlot}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{strip}()},
\code{\link{time.lcModel}()},
\code{\link{trajectoryAssignments}()}
}
\concept{lcModel functions}
