% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latrend.R
\name{createTestDataFold}
\alias{createTestDataFold}
\title{Create the test fold data for validation}
\usage{
createTestDataFold(data, trainData, id = getOption("latrend.id"))
}
\arguments{
\item{data}{A \code{data.frame} representing the complete dataset.}

\item{trainData}{A \code{data.frame} representing the training data, which should be a subset of \code{data}.}

\item{id}{The trajectory identifier variable.}
}
\description{
Create the test fold data for validation
}
\examples{
data(latrendData)

if (require("caret")) {
  trainDataList <- createTrainDataFolds(latrendData, id = "Id", folds = 10)
  testData1 <- createTestDataFold(latrendData, trainDataList[[1]], id = "Id")
}
}
\seealso{
createTrainDataFolds

Other validation methods: 
\code{\link{createTestDataFolds}()},
\code{\link{createTrainDataFolds}()},
\code{\link{latrendBoot}()},
\code{\link{latrendCV}()},
\code{\link{lcModel-data-filters}}
}
\concept{validation methods}
