\name{confint.lvmfit}
\alias{confint.lvmfit}
\alias{confint.multigroupfit}
\title{Calculate confidence limits for parameters}
\usage{
  \method{confint}{lvmfit} (object,
    parm = 1:length(coef(object)), level = 0.95,
    profile = FALSE, curve = FALSE, n = 20,
    interval = NULL, lower = TRUE, upper = TRUE, ...)
}
\arguments{
  \item{object}{\code{lvm}-object.}

  \item{parm}{Index of which parameters to calculate
  confidence limits for.}

  \item{level}{Confidence level}

  \item{profile}{Logical expression defining whether to
  calculate confidence limits via the profile log
  likelihood}

  \item{curve}{if FALSE and profile is TRUE, confidence
  limits are returned. Otherwise, the profile curve is
  returned.}

  \item{n}{Number of points to evaluate profile
  log-likelihood in over the interval defined by
  \code{interval}}

  \item{interval}{Interval over which the profiling is
  done}

  \item{lower}{If FALSE the lower limit will not be
  estimated (profile intervals only)}

  \item{upper}{If FALSE the upper limit will not be
  estimated (profile intervals only)}

  \item{\dots}{Additional arguments to be passed to the low
  level functions}
}
\value{
  A 2xp matrix with columns of lower and upper confidence
  limits
}
\description{
  Calculate Wald og Likelihood based (profile likelihood)
  confidence intervals
}
\details{
  Calculates either Wald confidence limits:
  \deqn{\hat{\theta} \pm
  z_{\alpha/2}*\hat\sigma_{\hat\theta}} or profile
  likelihood confidence limits, defined as the set of value
  \eqn{\tau}:
  \deqn{logLik(\hat\theta_{\tau},\tau)-logLik(\hat\theta)<
  q_{\alpha}/2}

  where \eqn{q_{\alpha}} is the \eqn{\alpha} fractile of
  the \eqn{\chi^2_1} distribution, and
  \eqn{\hat\theta_{\tau}} are obtained by maximizing the
  log-likelihood with tau being fixed.
}
\examples{
m <- lvm(y~x)
d <- sim(m,100)
e <- estimate(y~x, d)
confint(e,3,profile=TRUE)
confint(e,3)
\dontrun{
B <- bootstrap(e,R=100)
B
}
}
\author{
  Klaus K. Holst
}
\seealso{
  \code{\link{bootstrap}{lvm}}
}
\keyword{models}
\keyword{regression}

