% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sCorrect.R
\name{sCorrect}
\alias{sCorrect}
\alias{sCorrect.lm}
\alias{sCorrect.gls}
\alias{sCorrect.lme}
\alias{sCorrect.lvmfit}
\alias{sCorrect.lvmfit2}
\alias{sCorrect<-}
\alias{sCorrect<-.lm}
\alias{sCorrect<-.gls}
\alias{sCorrect<-.lme}
\alias{sCorrect<-.lvmfit}
\alias{sCorrect<-.lvmfit2}
\title{Compute the Derivative of the Information Matrix}
\usage{
sCorrect(object, ...)

\method{sCorrect}{lm}(object, adjust.Omega = TRUE, adjust.n = TRUE,
  score = TRUE, df = TRUE, numeric.derivative = FALSE, param = NULL,
  data = NULL, tol = 1e-05, n.iter = 20, trace = 0, ...)

\method{sCorrect}{gls}(object, cluster, adjust.Omega = TRUE,
  adjust.n = TRUE, score = TRUE, df = TRUE, numeric.derivative = FALSE,
  param = NULL, data = NULL, tol = 1e-05, n.iter = 20, trace = 0, ...)

\method{sCorrect}{lme}(object, cluster, adjust.Omega = TRUE,
  adjust.n = TRUE, score = TRUE, df = TRUE, numeric.derivative = FALSE,
  param = NULL, data = NULL, tol = 1e-05, n.iter = 20, trace = 0, ...)

\method{sCorrect}{lvmfit}(object, adjust.Omega = TRUE, adjust.n = TRUE,
  score = TRUE, df = TRUE, numeric.derivative = FALSE, param = NULL,
  data = NULL, tol = 1e-05, n.iter = 20, trace = 0, ...)

\method{sCorrect}{lvmfit2}(object, ...)

sCorrect(x, ...) <- value

\method{sCorrect}{lm}(x, ...) <- value

\method{sCorrect}{gls}(x, ...) <- value

\method{sCorrect}{lme}(x, ...) <- value

\method{sCorrect}{lvmfit}(x, ...) <- value

\method{sCorrect}{lvmfit2}(x, ...) <- value
}
\arguments{
\item{object, x}{a \code{gls}, \code{lme}, or \code{lvm} object.}

\item{...}{[internal] only used by the generic method or by the <- methods.}

\item{adjust.Omega}{[logical] should the standard errors of the coefficients be corrected for small sample bias?}

\item{adjust.n}{[logical] should the correction for the degree of freedom be performed?}

\item{score}{[internal] export the score.}

\item{df}{[logical] should the first derivative of the expected information matrix be computed. Required when computing the degrees of freedom of the test statistics.}

\item{numeric.derivative}{[logical] should a numerical derivative be used to compute the first derivative of the information matrix?
Otherwise an analytic formula is used.}

\item{param}{[numeric vector, optional] the values of the parameters at which to perform the correction.}

\item{data}{[data.frame, optional] the dataset relative to which the correction should be performed.}

\item{tol}{[numeric >0] the minimum absolute difference between two estimation of the small sample bias.
Below this value, the algorithm used to estimate the bias stop.}

\item{n.iter}{[integer >0] the maximum number of iterations used to estimate the small sample bias of the residual variance-covariance matrix.}

\item{trace}{[logical] should the execution of the function be traced.}

\item{cluster}{[integer vector] the grouping variable relative to which the observations are iid.
Only required for \code{gls} models with no correlation argument.}

\item{value}{[logical] value for the arguments \code{adjust.Omega} and \code{adjust.n}.}
}
\description{
Compute the derivative of the information matrix.
}
\concept{
small sample inference

derivative of the score equation
n <- 5e1
p <- 3
X.name <- paste0("X",1:p)
link.lvm <- paste0("Y~",X.name)
formula.lvm <- as.formula(paste0("Y~",paste0(X.name,collapse="+")))

m <- lvm(formula.lvm)
distribution(m,~Id) <- sequence.lvm(0)
set.seed(10)
d <- sim(m,n)

## linear model
e.lm <- lm(formula.lvm,data=d)
system.time(
sCorrect(e.lm) <- TRUE
)

## gls model
library(nlme)
e.gls <- gls(formula.lvm, data = d, method = "ML")
sCorrect(e.gls, cluster = 1:NROW(d)) <- TRUE
summary2(e.gls)

## latent variable model
e.lvm <- estimate(lvm(formula.lvm),data=d)
sCorrect(e.lvm) <- TRUE
summary2(e.lvm)
}
