% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skeleton.R
\name{skeleton}
\alias{skeleton}
\alias{skeleton.lvm}
\alias{skeleton.lvmfit}
\alias{skeletonDtheta}
\alias{skeletonDtheta.lvm}
\alias{skeletonDtheta.lvmfit}
\alias{skeletonDtheta2}
\alias{skeletonDtheta2.lvm}
\alias{skeletonDtheta2.lvmfit}
\title{Pre-computation for the Score}
\usage{
skeleton(object, ...)

\method{skeleton}{lvm}(object, as.lava, name.endogenous, name.latent, ...)

\method{skeleton}{lvmfit}(object, skeleton, param, data, name.endogenous,
  name.latent, ...)

skeletonDtheta(object, ...)

\method{skeletonDtheta}{lvm}(object, data, df.param.all, param2originalLink,
  name.endogenous, name.latent, ...)

\method{skeletonDtheta}{lvmfit}(object, dtheta, name.endogenous, name.latent, B,
  alpha.XGamma, Lambda, Psi, ...)

skeletonDtheta2(object, ...)

\method{skeletonDtheta2}{lvm}(object, data, df.param.all, param2originalLink,
  name.latent, ...)

\method{skeletonDtheta2}{lvmfit}(object, dtheta, d2theta, name.endogenous,
  name.latent, B, Lambda, Psi, ...)
}
\arguments{
\item{object}{a \code{lvm} object.}

\item{...}{[internal] only used by the generic method.}

\item{as.lava}{[logical] should the name of the links be used to name the coefficient?
Otherwise uses the labels (when defined) of each coefficient.}

\item{name.endogenous}{[character vector] name of the endogenous variables}

\item{name.latent}{[character vector] name of the latent variables}

\item{data}{[data.frame, optional] data set.}

\item{df.param.all}{[data.frame] output of \code{\link{coefType}} containing the type of each coefficient.}

\item{param2originalLink}{[named character vector] matching between the name of the coefficient in lava and their label.}

\item{B, alpha.XGamma, Lambda, Psi}{[matrix] pre-computed matrix.}

\item{OD}{[list] the pre-computed quantities for the second derivatives.}

\item{p}{[numeric vector, optional] vector of coefficients at which to evaluate the score.}
}
\description{
Pre-compute quantities that are necessary to compute the score of a lvm model.
}
\details{
When the use specify names for the coefficients (e.g. Y1[mu:sigma]) or uses constrains (Y1~beta*X1), \code{as.lava=FALSE} will use the names specified by the user (e.g. mu, sigma, beta) while \code{as.lava=TRUE} will use the name of the first link defining the coefficient.
}
\examples{
\dontrun{
skeleton <- lavaSearch2::skeleton
skeleton.lvm <- lavaSearch2::skeleton.lvm
skeleton.lvmfit <- lavaSearch2::skeleton.lvmfit

## without constrain
m <- lvm(Y1~X1+X2+eta,Y2~X3+eta,Y3~eta)
latent(m) <- ~eta

e <- estimate(m,sim(m,1e2))
M.data <- as.matrix(model.frame(e))

skeleton(e$model, as.lava = TRUE,
         name.endogenous = endogenous(e), n.endogenous = 3,
         name.latent = latent(e), 
         update.value = FALSE)
skeleton(e, data = M.data, p = pars(e), as.lava = TRUE,
         name.endogenous = endogenous(e), n.endogenous = 3,
         name.latent = latent(e), 
         update.value = TRUE)

## with constrains
m <- lvm(Y[mu:sigma] ~ beta*X1+X2)
e <- estimate(m, sim(m,1e2))
M.data <- as.matrix(model.frame(e))

skeleton(e$model, as.lava = TRUE,
         name.endogenous = "Y", n.endogenous = 1,
         name.latent = NULL, 
         update.value = FALSE)$skeleton

skeleton(e, data = M.data, p = pars(e), as.lava = FALSE,
         name.endogenous = "Y", n.endogenous = 1,
         name.latent = NULL, 
         update.value = FALSE)$skeleton

}
}
\concept{
small sample inference

derivative of the score equation
}
\keyword{internal}
