% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leverage.R
\name{leverage2}
\alias{leverage2}
\alias{leverage2.lm}
\alias{leverage2.gls}
\alias{leverage2.lme}
\alias{leverage2.lvmfit}
\alias{leverage2.lm2}
\alias{leverage2.gls2}
\alias{leverage2.lme2}
\alias{leverage2.lvmfit2}
\title{Extract Leverage Values}
\usage{
leverage2(object, ...)

\method{leverage2}{lm}(object, param = NULL, data = NULL, ...)

\method{leverage2}{gls}(object, param = NULL, data = NULL, ...)

\method{leverage2}{lme}(object, param = NULL, data = NULL, ...)

\method{leverage2}{lvmfit}(object, param = NULL, data = NULL, ...)

\method{leverage2}{lm2}(object, param = NULL, data = NULL, ...)

\method{leverage2}{gls2}(object, param = NULL, data = NULL, ...)

\method{leverage2}{lme2}(object, param = NULL, data = NULL, ...)

\method{leverage2}{lvmfit2}(object, param = NULL, data = NULL, ...)
}
\arguments{
\item{object}{a \code{lm2}, \code{gls2}, \code{lme2}, or \code{lvmfit2} object.}

\item{...}{arguments to be passed to \code{sCorrect}.}

\item{param}{[optional] the fitted parameters.}

\item{data}{[optional] the data set.}
}
\value{
a matrix containing the leverage relative to each sample (in rows)
and each endogenous variable (in column).
}
\description{
Extract leverage values from a Gaussian linear model.
}
\details{
The leverage are defined as the partial derivative of the fitted values with respect to the observations.
\deqn{
leverage_i = \frac{\partial \hat{Y}_i}{\partial Y_i}
}
See Wei et al. (1998). \cr \cr

If argument \code{p} or \code{data} is not null, then the small sample size correction is recomputed to correct the residuals.
}
\examples{
## simulate data
set.seed(10)
m <- lvm(Y1~eta,Y2~eta,Y3~eta)
latent(m) <- ~eta
d <- lava::sim(m,20, latent = FALSE)

## standard linear model
e.lm <- lm(Y1~Y2, data = d)

sCorrect(e.lm) <- TRUE
range(as.double(leverage2(e.lm)) - influence(e.lm)$hat)

## latent variable model
e.lvm <- estimate(m, data = d)
sCorrect(e.lvm) <- TRUE
leverage2(e.lvm)

}
\references{
Bo-Cheng Wei et al., Generalized Leverage and its applications (1998), Scandinavian Journal of Statistics 25:1:25-37.
}
\seealso{
\code{\link{sCorrect}} to obtain \code{lm2}, \code{gls2}, \code{lme2}, or \code{lvmfit2} objects.
}
\concept{
small sample inference
}
