% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hex_grid.R
\name{lawn_hex_grid}
\alias{lawn_hex_grid}
\title{Create a HexGrid}
\usage{
lawn_hex_grid(extent, cellWidth, units)
}
\arguments{
\item{extent}{(numeric) extent in [minX, minY, maxX, maxY] order}

\item{cellWidth}{(integer) width of each cell}

\item{units}{(character) units to use for cellWidth, one of 'miles' or
'kilometers'}
}
\value{
\code{\link{data-FeatureCollection}} grid of points
}
\description{
Takes a bounding box and a cell size in degrees and returns a
\code{\link{data-FeatureCollection}} of flat-topped hexagons
(\code{\link{data-Polygon}} features) aligned in an "odd-q" vertical
grid as described in Hexagonal Grids
\url{http://www.redblobgames.com/grids/hexagons/}
}
\examples{
lawn_hex_grid(c(-96,31,-84,40), 50, 'miles')
lawn_hex_grid(c(-96,31,-84,40), 30, 'miles')
}
\seealso{
Other interpolation: \code{\link{lawn_isolines}},
  \code{\link{lawn_planepoint}},
  \code{\link{lawn_point_grid}},
  \code{\link{lawn_square_grid}}, \code{\link{lawn_tin}},
  \code{\link{lawn_triangle_grid}}
}

