% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mma.test.R
\name{mma.test}
\alias{mma.test}
\title{Mudholkar--McDermott--Aumont Test for Ordered Variances for Normal Samples}
\usage{
mma.test(y, group, tail = c("right", "left", "both"))
}
\arguments{
\item{y}{a numeric vector of data values.}

\item{group}{factor of the data.}

\item{tail}{the default option is \code{"right"}, corresponding to an increasing
trend in variances as the one-sided alternative;  \code{"left"} corresponds to a
decreasing trend in variances, and  \code{"both"} corresponds to any
(increasing or decreasing) monotonic trend in variances as the two-sided alternative.}
}
\value{
A list with the following components:
\item{T}{the statistic and \eqn{p}-value of the test based on the Tippett \eqn{p}-value combination.}
\item{F}{the statistic and \eqn{p}-value of the test based on the Fisher \eqn{p}-value combination.}
\item{N}{the statistic and \eqn{p}-value of the test based on the Liptak \eqn{p}-value combination.}
\item{L}{the statistic and \eqn{p}-value of the test based on the Mudholkar--George \eqn{p}-value combination.}

Each of the list elements is a list of class \code{"htest"} with the following elements:
\item{statistic}{the value of the test statistic.}
\item{p.value}{the \eqn{p}-value of the test.}
\item{method}{type of test performed.}
\item{data.name}{a character string giving the name of the data.}
}
\description{
Test for a monotonic trend in variances for normal samples. The test statistic 
is based on a combination of the finite intersection approach and the classical 
\eqn{F} (variance ratio) test \insertCite{Mudholkar_etal_1993}{lawstat}. 
By default, \code{NA}s are omitted.
}
\examples{
data(pot)
mma.test(pot[, "obs"], pot[, "type"], tail = "left")$N

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{neuhauser.hothorn.test}}, \code{\link{levene.test}}, 
\code{\link{lnested.test}}, \code{\link{ltrend.test}}, \code{\link{robust.mmm.test}}
}
\author{
Kimihiro Noguchi, Yulia R. Gel
}
\keyword{htest}
\keyword{variability}
