% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazyNumbers.R
\docType{methods}
\name{is.na}
\alias{is.na}
\alias{is.na,lazyVector-method}
\alias{is.na,lazyMatrix-method}
\alias{anyNA}
\alias{anyNA,lazyVector-method}
\alias{anyNA,lazyMatrix-method}
\title{Missing lazy values}
\usage{
\S4method{is.na}{lazyVector}(x)

\S4method{is.na}{lazyMatrix}(x)

\S4method{anyNA}{lazyVector}(x, recursive = FALSE)

\S4method{anyNA}{lazyMatrix}(x, recursive = FALSE)
}
\arguments{
\item{x}{a lazy vector or a lazy matrix}

\item{recursive}{ignored}
}
\value{
The \code{is.na} function returns a logical vector or a 
  logical matrix, and the \code{anyNA} function returns a logical value.
}
\description{
Check whether values are missing in lazy vectors and lazy 
  matrices.
}
\note{
The \code{is.na} function does not detect lazy NaN numbers; see 
  the note in \code{\link{isNaN_or_Inf}}.
}
\examples{
is.na(NA_lazy_)
is.na(lazyvec(c(1, 2, NA, NaN, Inf)))
anyNA(lazyvec(c(1, 2, NA)))
}
