% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_if_optimize.R
\name{check_if_optimize}
\alias{check_if_optimize}
\title{Function check_if_optimize.}
\usage{
check_if_optimize(x, path_trading_robot, num_trades_to_consider = 10,
  profit_factor_limit = 0.7, demo_mode = FALSE, write_mode = FALSE)
}
\arguments{
\item{x}{- dataframe containing trading results}

\item{path_trading_robot}{- path of trading robot repository. must contain folder TEST with file Setup.csv.
File Setup.csv contains a table with magic numbers under test}

\item{num_trades_to_consider}{- Number of trades to calculate profit factor}

\item{profit_factor_limit}{- Limit below which trading robot considered not working properly}

\item{demo_mode}{- When true function uses package test dataset}

\item{write_mode}{- When true function will write result to the file located in the temporary directory}
}
\value{
function returns a dataframe with systems that should be optimized
}
\description{
Purpose of this function is to verify trading system functionality by analysing
profit factor on the last trades. Whenever trading robot has profit factor value below certain limit
function will write a file log indicating which trading systems need to be maintained.
}
\details{
Whenever there will be not enough trades then empty file will be written to the destination
}
\examples{

library(lazytrade)
library(tidyverse)
library(lubridate)
DFT1 <- import_data(trade_log_file = system.file("extdata",
                                                 "OrdersResultsT1.csv",
                                                 package = "lazytrade"),
                    demo_mode = TRUE)


# without writing to the file
DFT1 \%>\% check_if_optimize(num_trades_to_consider = 10,
                           profit_factor_limit = 1.2,
                           demo_mode = TRUE,
                           write_mode = FALSE)

# function will write to the temporary file
DFT1 \%>\% check_if_optimize(num_trades_to_consider = 10,
                           profit_factor_limit = 1.2,
                           demo_mode = TRUE,
                           write_mode = TRUE)


}
\author{
(C) 2019 Vladimir Zhbanko
}
