% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.R
\name{zshrink}
\alias{zshrink}
\title{Shrinks Fisher-z transformed correlation estimates and returns resulting
correlation estimates.}
\usage{
zshrink(zmat, smat, ...)
}
\arguments{
\item{zmat}{The matrix of Fisher-z transformed correlation estimates.}

\item{smat}{The matrix of standard errors of the Fisher-z transformed
correlation estimates.}

\item{...}{Additional arguments to pass to \code{\link[ashr]{ash}()}.}
}
\value{
A matrix of correlation estimates. These are posterior means
of the correlation estimates after applying the CorShrink method
(Dey and Stephens, 2018).
}
\description{
This function is a wrapper for adaptive shrinkage (Stephens, 2017) on the
Fisher-z transformed estimates of the Pearson correlation. This approach
was proposed in Dey and Stephens (2018) but is re-implemented here for now
since the CorShrink package is not available on CRAN.
}
\references{
\itemize{
\item{Stephens, Matthew. "False discovery rates: a new deal."
Biostatistics 18, no. 2 (2017): 275-294.}
\item{Dey, Kushal K., and Matthew Stephens. "CorShrink:
Empirical Bayes shrinkage estimation of correlations,
with applications." bioRxiv (2018): 368316.}
}
}
\author{
David Gerard
}
