# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Gets Distances Between Variables
#'
#' @param data (numeric matrix) Data with variables in the columns.
#' @param distance (string) Determines how distances are calculated. It can be \code{correlation}, \code{absCorrelation}, \code{euclidean}, \code{manhattan}, \code{maximum}.
#' @param correlation (string) If \code{distance} is correlation, it determines the type of the correlation. It can be \code{pearson}, \code{spearman}.
#' @param checkNan (bool) If false, \code{NAN}s are not omitted.
#'
#' @return A symmetric matrix (lower triangle as a vector).
#'
#' @export
GetDistance <- function(data, distance = "correlation", correlation = "pearson", checkNan = TRUE) {
    .Call('_ldt_GetDistance', PACKAGE = 'ldt', data, distance, correlation, checkNan)
}

#' Hierarchical Clustering
#'
#'
#' @param distances (numeric vector) Determines the distances. This must be the lower triangle of a (symmetric) distance matrix (without the diagonal).
#' @param numVariables (int) Determines the number of variables. This should hold: '2 * length(\code{distances}) = \code{numVariables}(\code{numVariables} - 1)'.
#' @param linkage (string) Determines how Distances are calculated in a left-right node merge. It can be \code{single}, \code{complete}, \code{uAverage}, \code{wAverage}, \code{ward}.
#'
#' @return A list:
#' \item{merge}{(integer matrix)}
#' \item{height}{(numeric vector)}
#' \item{order}{(integer vector)}
#'
#' @export
ClusterH <- function(distances, numVariables, linkage = "single") {
    .Call('_ldt_ClusterH', PACKAGE = 'ldt', distances, numVariables, linkage)
}

#' Groups Variables with Hierarchical Clustering
#'
#' @details The results might be different from R's 'cutree' function. I don't know how 'cutree' works, but here I iterate over the nodes and whenever a split occurs, I add a group until the required number of groups is reached.
#'
#' @param data (numeric matrix) Data with variables in the columns.
#' @param nGroups (int) Number of groups
#' @param threshold (double) A threshold for omitting variables. If distance between two variables in a group is less than this value, the second one will be omitted. Note that a change in the order of the columns might change the results.
#' @param distance (string)  Determines how distances are calculated. It can be \code{correlation}, \code{absCorrelation}, \code{euclidean}, \code{manhattan}, \code{maximum}.
#' @param linkage (string) Determines how Distances are calculated in a left-right node merge. It can be \code{single}, \code{complete}, \code{uAverage}, \code{wAverage}, \code{ward}.
#' @param correlation (string) If \code{distance} is correlation, it determines the type of the correlation. It can be \code{pearson}, \code{spearman}.
#'
#' @return A list:
#' \item{groups}{(List of integer vectors) indexes of variables in each group.}
#' \item{removed}{(integer vector) indexes of removed variables.}
#'
#' @export
ClusterHGroup <- function(data, nGroups = 2L, threshold = 0, distance = "correlation", linkage = "single", correlation = "pearson") {
    .Call('_ldt_ClusterHGroup', PACKAGE = 'ldt', data, nGroups, threshold, distance, linkage, correlation)
}

#' Discrete Choice Search
#'
#' @param y (numeric matrix) endogenous data with variable in the column.
#' @param x (numeric matrix) exogenous data with variables in the columns.
#' @param w (numeric vector) weights of the observations in \code{y}. null means equal weights.
#' @param xSizes (nullable int vector) Number of exogenous variables in the regressions. E.g., c(1,2) means the model set contains all the regressions with 1 and 2 exogenous variables. If null, c(1) is used.
#' @param xPartitions (nullable list of int vector) a partition over the indexes of the exogenous variables. No regression is estimated with two variables in the same group. If null, each variable is placed in its own group and the size of the model set is maximized.
#' @param costMatrices (list of numeric matrix) each frequency cost matrix determines how to score the calculated probabilities. Given the number of choices 'n', a frequency cost matrix is a 'm x n+1' matrix. The first column determines the thresholds. Cells in the j-th column determines the costs corresponding to the (j-1)-th choice in \code{y}. It can be null if it is not selected in \code{measureOptions}.
#' @param searchLogit (bool) if \code{TRUE}, logit regressions are added to the model set.
#' @param searchProbit (bool) if \code{TRUE}, probit regressions are added to the model set.
#' @param optimOptions (nullable list) Newton optimization options. see \code{[GetNewtonOptions()]}.
#' @param aucOptions (nullable list) AUC calculation options. see \code{[GetRocOptions()]}.
#' @param measureOptions (nullable list) see \code{[GetMeasureOptions()]}.
#' @param modelCheckItems (nullable list) see \code{[GetModelCheckItems()]}.
#' @param searchItems (nullable list) see \code{[GetSearchItems()]}.
#' @param searchOptions (nullable list) see \code{[GetSearchOptions()]}.
#'
#' @return A list
#'
#' @export
DcSearch <- function(y, x, w = NULL, xSizes = NULL, xPartitions = NULL, costMatrices = NULL, searchLogit = TRUE, searchProbit = FALSE, optimOptions = NULL, aucOptions = NULL, measureOptions = NULL, modelCheckItems = NULL, searchItems = NULL, searchOptions = NULL) {
    .Call('_ldt_DcSearch', PACKAGE = 'ldt', y, x, w, xSizes, xPartitions, costMatrices, searchLogit, searchProbit, optimOptions, aucOptions, measureOptions, modelCheckItems, searchItems, searchOptions)
}

#' Estimates an Discrete Choice Model
#'
#' @param y (numeric matrix) Data with dependent variable in the column. Given the number of choices 'n', it must contain 0,1,...,n-1 and 'sum(y==i)>0' for i=0,...,n-1.
#' @param x (numeric matrix) Exogenous data with variables in the columns.
#' @param w (numeric vector) Weights of the observations in \code{y}. Null means equal weights.
#' @param distType (string) Distribution assumption. It can be \code{logit} or \code{probit}.
#' @param newX (numeric matrix) If not null, probabilities are projected for each row of this matrix.
#' @param pcaOptionsX (list) A list of options in order to use principal components of the \code{x}, instead of the actual values. set null to disable. Use [GetPcaOptions()] for initialization.
#' @param costMatrices (list of matrices) Each cost table determines how you score the calculated probabilities.
#' @param aucOptions (nullable list) AUC calculation options. see \code{[GetRocOptions()]}.
#' @param simFixSize (int) Number of pseudo out-of-sample simulations. Use zero to disable the simulation. (see [GetMeasureOptions()]).
#' @param simTrainRatio (double) Size of the training sample as a ratio of the number of the observations. It is effective only if \code{simTrainFixSize} is zero.
#' @param simTrainFixSize (int) A fixed size for the training sample. If zero, \code{simTrainRatio} is used.
#' @param simSeed (int) A seed for the pseudo out-of-sample simulation.
#' @param weightedEval (bool) If true, weights will be used in evaluations.
#' @param printMsg (bool) Set false to disable printing the details.
#'
#' @return A list:
#'
#' @export
DcEstim <- function(y, x, w = NULL, distType = "logit", newX = NULL, pcaOptionsX = NULL, costMatrices = NULL, aucOptions = NULL, simFixSize = 200L, simTrainRatio = 0.5, simTrainFixSize = 0L, simSeed = 0L, weightedEval = FALSE, printMsg = FALSE) {
    .Call('_ldt_DcEstim', PACKAGE = 'ldt', y, x, w, distType, newX, pcaOptionsX, costMatrices, aucOptions, simFixSize, simTrainRatio, simTrainFixSize, simSeed, weightedEval, printMsg)
}

#' Creates a Cross-Section Frequency
#'
#' This frequency is generally for indexed (or, non-time-series) data. It is an integer that represents the position of the observation.
#'
#' @param position Position of the observation
#'
#' @details
#' \itemize{
#' \item **Value String:** \code{"#"} (number is \code{position})
#' \item **Class String:** \code{"cs"}
#' }
#'
#' @return An object of class 'ldtf'
#' @export
F_CrossSection <- function(position) {
    .Call('_ldt_F_CrossSection', PACKAGE = 'ldt', position)
}

#' Creates a \code{Yearly} Frequency
#'
#' Frequency for a series that happens every year
#'
#' @param year Year of the observation
#'
#' @details
#' \itemize{
#' \item **Value String:** \code{"#"} (number is \code{year})
#' \item **Class String:** \code{"y"}
#' }
#'
#' @return An object of class 'ldtf'
#' @export
F_Yearly <- function(year) {
    .Call('_ldt_F_Yearly', PACKAGE = 'ldt', year)
}

#' Creates a \code{Quarterly} Frequency
#'
#' Frequency for a series that happens every quarter
#'
#' @param year Year of the observation
#' @param quarter Quarter of the observation (1 to 4)
#'
#' @details
#' \itemize{
#' \item **Value String:** \code{"#q#"} (first # is \code{year}, second # is
#'  \code{quarter}; e.g., 2010q3 or 2010q4.
#'  Note that 2000q0 or 2000q5 are invalid.
#' \item **Class String:** \code{"q"}
#' }
#'
#' @return An object of class 'ldtf'
#' @export
F_Quarterly <- function(year, quarter) {
    .Call('_ldt_F_Quarterly', PACKAGE = 'ldt', year, quarter)
}

#' Creates a \code{Monthly} Frequency
#'
#' Frequency for a series that happens every month
#'
#' @param year Year of the observation
#' @param month Month of the observation
#'
#' @details
#' \itemize{
#' \item **Value String:** \code{"#m#"} (first # is the \code{year}, second # is
#'  \code{month} (1 to 12); e.g., 2010m8 or 2010m12.
#'  Note that 2000m0 or 2000m13 are invalid.
#' \item **Class String:** \code{"m"}
#' }
#'
#' @return An object of class 'ldtf'
#' @export
F_Monthly <- function(year, month) {
    .Call('_ldt_F_Monthly', PACKAGE = 'ldt', year, month)
}

#' Creates a \code{Multi-Yearly} Frequency
#'
#' Frequency for a series that happens every \code{z} years
#'
#' @param year Year of the observation
#' @param z Number of years
#'
#' @details
#' \itemize{
#' \item **Value String:** \code{"#"} (similar to \code{Yearly})
#' \item **Class String:** \code{"z#"} (integer represents the
#' \code{z}; e.g., z3)
#' }
#'
#' @return An object of class 'ldtf'
#' @export
F_MultiYearly <- function(year, z) {
    .Call('_ldt_F_MultiYearly', PACKAGE = 'ldt', year, z)
}

#' Creates an \code{X-Times-A-Year} Frequency
#'
#' Frequency for a series that happens \code{x} times every year
#'
#' @param year Year of the observation
#' @param x Number of observation in each year
#' @param position Position of the current observation
#'
#' @details
#' \itemize{
#' \item **Value String:** \code{"#:#"} (first # is \code{year} and second # is
#'  \code{position};
#'  e.g., 2010:8/12 or 2010:10/10.
#'  Note that 2000:0/2 or 2000:13/12 are invalid.
#' \item **Class String:** \code{"y#"} (the number is \code{x})
#' }
#'
#' @return An object of class 'ldtf'
#' @export
F_XTimesAYear <- function(year, x, position) {
    .Call('_ldt_F_XTimesAYear', PACKAGE = 'ldt', year, x, position)
}

#' Creates an \code{X-Times-Z-Years} Frequency
#'
#' Frequency for a series that happens \code{x} times each \code{z} years
#'
#' @param year Year of the observation
#' @param x Number of partitons in each z years
#' @param z Number of years
#' @param position Position of the current observation
#'
#' @details
#' \itemize{
#' \item **Value String:** \code{"#:#"} (Similar to \code{X-Times-A-Year})
#' \item **Class String:** \code{"x#z#"} (first # is \code{x}, second # is \code{z};
#' e.g., x23z4 means 23 times every 4 years)
#' }
#'
#' @return An object of class 'ldtf'
#' @export
F_XTimesZYear <- function(year, x, z, position) {
    .Call('_ldt_F_XTimesZYear', PACKAGE = 'ldt', year, x, z, position)
}

#' Creates a \code{Weekly} Frequency
#'
#' Frequency for a series that happens every week
#'
#' @param year Year of the observation
#' @param month Month of the observation
#' @param day Day of the observation. It points to the first day of the week
#'
#' @details
#' \itemize{
#' \item **Value String:** \code{"YYYYMMDD"} (\code{YYYY} is the \code{year}, \code{MM} is \code{month} and \code{DD} is \code{day})
#' \item **Class String:** \code{"w"}
#' }
#'
#' @return An object of class 'ldtf'
#' @export
F_Weekly <- function(year, month, day) {
    .Call('_ldt_F_Weekly', PACKAGE = 'ldt', year, month, day)
}

#' Creates a \code{Multi-Weekly} Frequency
#'
#' Frequency for a series that happens every 'k' weeks
#'
#' @param year Year of the observation
#' @param month Month of the observation
#' @param day First day of the observation. It points to the first day of the week
#' @param k Number of weeks
#'
#' @details
#' \itemize{
#' \item **Value String:** \code{"YYYYMMDD"} (similar to \code{Weekly})
#' \item **Class String:** \code{"w#"} (the number is \code{k}; e.g., w3 means every 3 weeks)
#' }
#'
#' @return An object of class 'ldtf'
#' @export
F_MultiWeekly <- function(year, month, day, k) {
    .Call('_ldt_F_MultiWeekly', PACKAGE = 'ldt', year, month, day, k)
}

#' Creates a \code{Daily} Frequency
#'
#' Frequency for a series that happens every day
#'
#' @param year Year of the observation
#' @param month Month of the observation
#' @param day Day of the observation.
#'
#' @details
#' \itemize{
#' \item **Value String:** \code{"YYYYMMDD"} (similar to \code{Weekly})
#' \item **Class String:** \code{"d"}
#' }
#'
#' @return An object of class 'ldtf'
#' @export
F_Daily <- function(year, month, day) {
    .Call('_ldt_F_Daily', PACKAGE = 'ldt', year, month, day)
}

#' Creates an \code{Multi-Daily} Frequency
#'
#' Frequency for a series that happens every \code{k} days
#'
#' @param year Year of the observation
#' @param month Month of the observation
#' @param day First day of the observation
#' @param k Number of the days
#'
#' @details
#' \itemize{
#' \item **Value String:** \code{"YYYYMMDD"} (similar to \code{Weekly})
#' \item **Class String:** \code{"d#"} (the number is \code{k})
#' }
#'
#' @return An object of class 'ldtf'
#' @export
F_MultiDaily <- function(year, month, day, k) {
    .Call('_ldt_F_MultiDaily', PACKAGE = 'ldt', year, month, day, k)
}

#' Creates an \code{Daily-In-Week} Frequency
#'
#' Frequency for a series that happens every in the days of a week
#'
#' @param year Year of the observation
#' @param month Month of the observation
#' @param day First day of the observation
#' @param weekStart First day of the week. It can be \code{sun}, \code{mon},
#' \code{tue}, \code{wed}, \code{thu}, \code{fri}, and \code{sat}
#' @param weekEnd Last day of the week. See \code{weekStart}.
#' Together, they define the week
#' @param forward If current date in not in the week,
#' if true, it moves forward to the first day of the week.
#' Otherwise, it moves backward to the last day of the week.
#'
#' @details
#' \itemize{
#' \item **Value String:** \code{"YYYYMMDD"} (similar to \code{Weekly})
#' \item **Class String:** \code{"i:...-..."} (the first ... is \code{weekStart}
#' and the second ... is \code{weekEnd}; e.g., \code{i:mon-fri} means
#' a week that is from Monday to Friday)
#' }
#'
#' @return An object of class 'ldtf'
#' @export
F_DailyInWeek <- function(year, month, day, weekStart, weekEnd, forward) {
    .Call('_ldt_F_DailyInWeek', PACKAGE = 'ldt', year, month, day, weekStart, weekEnd, forward)
}

#' Creates an \code{List-String} Frequency
#'
#' Frequency for a series that is labeled by string
#'
#' @param items Items of the list
#' @param value Current item
#'
#' @details
#' \itemize{
#' \item **Value String:** \code{"..."} (in which ... is the \code{value})
#' \item **Class String:** \code{Ls} or \code{Ls:...} (in which ...
#' is the semi-colon separated \code{items})
#' }
#'
#' @return An object of class 'ldtf'
#' @export
F_ListString <- function(items, value) {
    .Call('_ldt_F_ListString', PACKAGE = 'ldt', items, value)
}

#' Creates an \code{List-Date} Frequency
#'
#' Frequency for a series that is labeled by dates
#'
#' @param items Items of the list in string format: \code{YYYYMMDD}
#' @param value Current value in string format: \code{YYYYMMDD}
#'
#' @details
#' \itemize{
#' \item **Value String:** \code{"YYYYMMDD"} (i.e., \code{item})
#' \item **Class String:** \code{Ld} or \code{Ld:...} (in which ...
#' is the semi-colon separated \code{items})
#' }
#'
#' @return An object of class 'ldtf'
#' @export
F_ListDate <- function(items, value) {
    .Call('_ldt_F_ListDate', PACKAGE = 'ldt', items, value)
}

#' Creates an 'Hourly' Frequency
#'
#' Frequency for a series that happens every hour
#'
#' @param day A 'Day-based' frequency such as \code{Daily} or \code{Daily-In-Week}
#' @param hour Index of hour in the day (1 to 24)
#'
#' @details
#' \itemize{
#' \item **Value String:** \code{"YYYYMMDD:#"} (the number is \code{hour})
#' \item **Class String:** \code{ho|...} (the ... is the 'Class String' of \code{day})
#' }
#'
#' @return An object of class 'ldtf'
#' @export
F_Hourly <- function(day, hour) {
    .Call('_ldt_F_Hourly', PACKAGE = 'ldt', day, hour)
}

#' Creates an 'Minute-ly' Frequency
#'
#' Frequency for a series that happens every minute
#'
#' @param day A 'Day-based' frequency such as daily or daily-in-week
#' @param minute Index of Minute in the day (1 to 1440)
#'
#' @details
#' \itemize{
#' \item **Value String:** \code{"YYYYMMDD:#"} (the number is \code{minute})
#' \item **Class String:** \code{mi|...} (the ... is the 'Class String' of \code{day})
#' }
#'
#' @return An object of class 'ldtf'
#' @export
F_Minute_ly <- function(day, minute) {
    .Call('_ldt_F_Minute_ly', PACKAGE = 'ldt', day, minute)
}

#' Creates an 'Second-ly' Frequency
#'
#' Frequency for a series that happens every second
#'
#' @param day A 'Day-based' frequency such as daily or daily-in-week
#' @param second Index of second in the day (1 to 86400)
#'
#' @details
#' \itemize{
#' \item **Value String:** \code{"YYYYMMDD:#"} (the number is \code{second})
#' \item **Class String:** \code{se|...} (the ... is the 'Class String' of \code{day})
#' }
#'
#' @return An object of class 'ldtf'
#' @export
F_Second_ly <- function(day, second) {
    .Call('_ldt_F_Second_ly', PACKAGE = 'ldt', day, second)
}

#' Creates an 'X-Times-A-Day' Frequency
#'
#' Frequency for a series that happens x times in a day
#'
#' @param day A 'Day-based' frequency such as daily or daily-in-week
#' @param x Number of observations in a day
#' @param position Current position
#'
#' @details
#' \itemize{
#' \item **Value String:** \code{"#"} (the number is \code{hour})
#' \item **Class String:** \code{"da#|..."} (the number is \code{x}
#' and ... is the 'Class String' of \code{day}))
#' }
#'
#' @return An object of class 'ldtf'
#' @export
F_XTimesADay <- function(day, x, position) {
    .Call('_ldt_F_XTimesADay', PACKAGE = 'ldt', day, x, position)
}

#' Converts an \code{ldtf} Object to String
#'
#' The format is explained in \code{F_?} functions.
#'
#' @param value value of the frequency. It must be an \code{ldtf}
#' object returned from \code{F_?} functions.
#'
#' @return An object of class 'ldtf'
#' @export
ToString_F <- function(value) {
    .Call('_ldt_ToString_F', PACKAGE = 'ldt', value)
}

#' Converts an \code{ldtf} Object to String
#'
#' The format is explained in \code{F_?} functions.
#'
#' @param value value of the frequency. It must be an \code{ldtf}
#' object returned from \code{F_?} functions.
#'
#' @return An object of class 'ldtf'
#' @export
ToClassString_F <- function(value) {
    .Call('_ldt_ToClassString_F', PACKAGE = 'ldt', value)
}

#' Similar to \code{ToString_F} and Return Value and Class as String
#'
#' The format is explained in \code{F_?} functions.
#'
#' @param value value of the frequency. It must be an \code{ldtf}
#' object returned from \code{F_?} functions.
#'
#' @return An object of class 'ldtf'
#' @export
ToString_F0 <- function(value) {
    .Call('_ldt_ToString_F0', PACKAGE = 'ldt', value)
}

#' Converts back a String to \code{ldtf} Object
#'
#' The format is explained in \code{F_?} functions.
#'
#' @param str value of the frequency. It must be an \code{ldtf}
#' object returned from \code{F_?} functions.
#' @param classStr class of the frequency
#'
#' @return An object of class 'ldtf'
#' @export
Parse_F <- function(str, classStr) {
    .Call('_ldt_Parse_F', PACKAGE = 'ldt', str, classStr)
}

#' Generates a Sequence for a frequency
#'
#'
#' @param start first element of the sequence. It must be an \code{ldtf}
#' object returned from \code{F_?} functions.
#' @param length Length of the sequence
#'
#' @return A list of strings
#' @export
Sequence_F <- function(start, length) {
    .Call('_ldt_Sequence_F', PACKAGE = 'ldt', start, length)
}

#' Options for ROC and AUC
#'
#' @param lowerThreshold (double) Lower bound for calculating partial AUC.
#' @param upperThreshold (double) Upper bound for calculating partial AUC.
#' @param epsilon (double) A value to ignore small floating point differences in comparing scores.
#' @param pessimistic (bool) If true, sequences of equally scored instances are treated differently and a pessimistic measure is calculated (see Fawcett (2006) An introduction to roc analysis, fig. 6).
#' @param costs (numeric vector) cost of each observations. If null, cost of all observations will be 1.
#' @param costMatrix (numeric matrix) a 2x2 cost matrix in which: (1,1) is cost of TN,
#' (2,2) is cost of TP, (1,2) is cost of FP and (2,1) is cost of FN. First
#' column is multiplied by the corresponding value in costs vector (see
#' Fawcett (2006), ROC graphs with instance-varying costs).
#'
#' @return A list with the given options.
#'
#' @export
GetRocOptions <- function(lowerThreshold = 0, upperThreshold = 1, epsilon = 1e-12, pessimistic = FALSE, costs = NULL, costMatrix = NULL) {
    .Call('_ldt_GetRocOptions', PACKAGE = 'ldt', lowerThreshold, upperThreshold, epsilon, pessimistic, costs, costMatrix)
}

#' Options for Nelder-Mead Optimization
#'
#' @param maxIterations (int) Maximum number of iterations.
#' @param epsilon (double) A small value to test convergence.
#' @param alpha (double) the reflection coefficient.
#' @param beta (double) the contraction coefficient.
#' @param gamma (double) the expansion coefficient.
#' @param scale (double) A scale in initializing the simplex.
#'
#' @return A list with the given options.
#'
#' @export
GetNelderMeadOptions <- function(maxIterations = 100L, epsilon = 1e-8, alpha = 1, beta = 0.5, gamma = 2, scale = 1) {
    .Call('_ldt_GetNelderMeadOptions', PACKAGE = 'ldt', maxIterations, epsilon, alpha, beta, gamma, scale)
}

#' Options for PCA
#'
#' @param ignoreFirst (int) Excludes variables at the beginning of data matrices (such as intercept) from PCA.
#' @param exactCount (int) Determines the number of components to be used. If zero, number of components are determined by the \code{cutoffRate}.
#' @param cutoffRate (double between 0 and 1) Determines the cutoff rate for cumulative variance ratio in order to determine the number of PCA components. It is not used if \code{exactCount} is positive.
#' @param max (int) Maximum number of components when \code{cutoffRate} is used.
#'
#' @return A list with the given options.
#'
#' @export
GetPcaOptions <- function(ignoreFirst = 1L, exactCount = 0L, cutoffRate = 0.8, max = 1000L) {
    .Call('_ldt_GetPcaOptions', PACKAGE = 'ldt', ignoreFirst, exactCount, cutoffRate, max)
}

#' Options for LMBFGS Optimization
#'
#' @param maxIterations (int) A positive integer for maximum number of iterations.
#' @param factor (double) A condition for stopping the iterations. The iteration will stop when (f^k - f^{k+1})/max{|f^k|,|f^{k+1}|,1} < \code{factor}*epsmch where epsmch is the machine precision, which is automatically generated by the code. Use e.g., 1e12 for low accuracy, 1e7 (default) for moderate accuracy and 1e1 for extremely high accuracy. default is 1e7
#' @param projectedGradientTol (double) The iteration will stop when \code{max{|proj g_i | i = 1, ..., n} < projectedGradientTol} where \code{pg_i} is the ith component of the projected gradient. default is zero.
#' @param maxCorrections (int) Maximum number of variable metric corrections allowed in the limited memory Matrix. default is 5.
#'
#' @return A list with the given options.
#'
#' @export
GetLmbfgsOptions <- function(maxIterations = 100L, factor = 1e7, projectedGradientTol = 0, maxCorrections = 5L) {
    .Call('_ldt_GetLmbfgsOptions', PACKAGE = 'ldt', maxIterations, factor, projectedGradientTol, maxCorrections)
}

#' Options for Newton Optimization
#'
#' @param maxIterations (int) Maximum number of iterations.
#' @param functionTol (double) A small value to test convergence of the objective function.
#' @param gradientTol (double) A small value to test convergence of the gradient.
#' @param useLineSearch (bool) If true, it uses line search.
#'
#' @return A list with the given options.
#'
#' @export
GetNewtonOptions <- function(maxIterations = 100L, functionTol = 1e-4, gradientTol = 0, useLineSearch = TRUE) {
    .Call('_ldt_GetNewtonOptions', PACKAGE = 'ldt', maxIterations, functionTol, gradientTol, useLineSearch)
}

#' Options for 'Search Items'
#'
#' @description Creates a list with predefined items which determines the information to be saved and retrieved.
#'
#' @param model (bool) If true, information about the models is saved.
#' @param type1 (bool) If true and implemented, extra information is saved. This can be the coefficients in the SUR search or predictions in VARMA search.
#' @param type2 (bool) If true and implemented, extra information is saved. This is similar to \code{type1}. **It is reserved for future updates.**
#' @param bestK (int) Number of best items to be saved in \code{model}, \code{type1}, or \code{type2} information.
#' @param all (bool) If true, all available information is saved.
#' @param inclusion (bool) If true, inclusion weights are saved in \code{model}.
#' @param cdfs (nullable numeric vector) Weighted average of the CDFs at each given point is calculated (for \code{type1} and \code{type2}).
#' @param extremeMultiplier (double) Determined the multiplier in the extreme bound analysis (for \code{type1} and \code{type2}).
#' @param mixture4 (bool) If true, the first 4 moments of the average distributions are calculated in \code{type1} and \code{type2}.
#'
#' @return A list with the given options.
#'
#' @export
GetSearchItems <- function(model = TRUE, type1 = FALSE, type2 = FALSE, bestK = 1L, all = FALSE, inclusion = FALSE, cdfs = NULL, extremeMultiplier = 0, mixture4 = FALSE) {
    .Call('_ldt_GetSearchItems', PACKAGE = 'ldt', model, type1, type2, bestK, all, inclusion, cdfs, extremeMultiplier, mixture4)
}

#' Options for 'Search Options'
#'
#' @description Creates a list with predefined Search options.
#'
#' @param parallel (bool) If true, it uses a parallel search. It generally changes the speed and memory usage.
#' @param reportInterval (int) Time interval (in seconds) for reporting the progress (if the change is significant). Set zero to disable.
#' @param printMsg (bool) Set false to disable printing the details.
#'
#' @return A list with the given options.
#'
#' @export
GetSearchOptions <- function(parallel = FALSE, reportInterval = 2L, printMsg = FALSE) {
    .Call('_ldt_GetSearchOptions', PACKAGE = 'ldt', parallel, reportInterval, printMsg)
}

#' Options for 'Model Check Items'
#'
#' @param estimation (bool) If true, model is estimated with all data. If false, you might get a 'best model' that cannot be estimated.
#' @param maxConditionNumber (double) Maximum value for the condition number (if implemented in the search).
#' @param minObsCount (int) Minimum value for the number of observations. Use 0 to disable.
#' @param minDof (int) Minimum value for the degrees of freedom (equation-wise). Use 0 to disable.
#' @param minOutSim (int) Minimum value for the number of valid out-of-sample simulations (if implemented in the search).
#' @param minR2 (double) Minimum value for R2 (if implemented in the search).
#' @param maxAic (double) Maximum value for AIC (if implemented in the search).
#' @param maxSic (double) Maximum value for SIC (if implemented in the search).
#' @param prediction (bool) If true, model data is predicted given all data. If false, you might get a 'best model' that cannot be used in prediction.
#' @param predictionBoundMultiplier (double) If positive, a bound is created by multiplying this value to the average growth rate. A model is ignored, if its prediction lies outside of this bound.
#'
#' @return A list with the given options.
#'
#' @export
GetModelCheckItems <- function(estimation = TRUE, maxConditionNumber = 1.7e308, minObsCount = 0L, minDof = 0L, minOutSim = 0L, minR2 = -1.7e308, maxAic = 1.7e308, maxSic = 1.7e308, prediction = FALSE, predictionBoundMultiplier = 4) {
    .Call('_ldt_GetModelCheckItems', PACKAGE = 'ldt', estimation, maxConditionNumber, minObsCount, minDof, minOutSim, minR2, maxAic, maxSic, prediction, predictionBoundMultiplier)
}

#' Options for 'Measuring Performance'
#'
#' @param typesIn (nullable string vector) Evaluations when model is estimated using all available data. It can be \code{aic}, \code{sic}, \code{frequencyCostIn}, \code{aucIn}. Null means no measure.
#' @param typesOut (nullable string vector) Evaluations in an pseudo out-of-sample simulation. It can be \code{sign}, \code{direction}, \code{rmse}, \code{scaledRmse}, \code{mae}, \code{scaledMae}, \code{crps}, \code{frequencyCostOut}, \code{aucOut}. Null means no measure.
#' @param simFixSize (int) Number of pseudo out-of-sample simulations. Use zero to disable the simulation.
#' @param trainFixSize (int) Number of data-points in the training sample in the pseudo out-of-sample simulation. If zero, \code{trainRatio} will be used.
#' @param trainRatio (double) Number of data-points, as a ratio of the available size, in the training sample in the pseudo out-of-sample simulation.
#' @param seed (int) A seed for random number generator. Use zero for a random value.
#' @param horizons (nullable integer vector) prediction horizons to be used in pseudo out-of-sample simulations, if model supports time-series prediction. If null, c(1) is used.
#' @param weightedEval (bool) If true, weights are used in evaluationg discrete-choice models
#' @return A list with the given options.
#'
#' @export
GetMeasureOptions <- function(typesIn = NULL, typesOut = NULL, simFixSize = 10L, trainRatio = 0.75, trainFixSize = 0L, seed = 0L, horizons = NULL, weightedEval = FALSE) {
    .Call('_ldt_GetMeasureOptions', PACKAGE = 'ldt', typesIn, typesOut, simFixSize, trainRatio, trainFixSize, seed, horizons, weightedEval)
}

#' Converts a Measure to Weight
#'
#' @param value (double) the measure
#' @param measureName (string) measure name
#'
#' @return the weight
#' @export
#'
#' @examples
#' weight <- GetWeightFromMeasure(-3.4, "sic")
GetWeightFromMeasure <- function(value, measureName) {
    .Call('_ldt_GetWeightFromMeasure', PACKAGE = 'ldt', value, measureName)
}

#' Converts a Measure to Weight
#'
#' @param value (double) the measure
#' @param measureName (string) measure name
#'
#' @return the measure
#' @export
#'
#' @examples
#' weight <- GetWeightFromMeasure(-3.4, "sic")
#' measure <- GetMeasureFromWeight(weight, "sic")
GetMeasureFromWeight <- function(value, measureName) {
    .Call('_ldt_GetMeasureFromWeight', PACKAGE = 'ldt', value, measureName)
}

#' ROC curve for a binary case
#'
#' It does not draw the ROC, but calculatates the required points. It also
#' Calculates the AUC with different options
#'
#' @param y (numeric vector, \code{Nx1}) Actual values
#' @param scores (numeric vector, \code{Nx1}) Calculated probabilities for the negative observations
#' @param weights (numeric vector, \code{Nx1}) Weights of the observations. Use \code{NULL} for equal weights.
#' @param options (list) More options. See [GetRocOptions()] function for details.
#' @param printMsg (bool) Set true to report some details.
#'
#' @return A list with the following items:
#' \item{N}{(integer) Number of observations}
#' \item{AUC}{(numeric) Value of AUC}
#' \item{Points}{(numeric matrix) Points for ploting ROC}
#'
#' @export
#'
#' @examples
#' y <- c(1, 0, 1, 0, 1, 1, 0, 0, 1, 0)
#' scores <- c(0.1, 0.2, 0.3, 0.5, 0.5, 0.5, 0.7, 0.8, 0.9, 1)
#' res1 = GetRoc(y,scores, printMsg = FALSE)
#' costs <- c(1,2,1,4,1,5,1,1,0.5,1)
#' costMatrix = matrix(c(0.02,-1,-3,3),2,2)
#' opt <- GetRocOptions(costs = costs, costMatrix = costMatrix)
#' res2 = GetRoc(y,scores,NULL,options = opt, printMsg = FALSE)
#' #plot(res1$Points)
#' #lines(res2$Points)
#'
GetRoc <- function(y, scores, weights = NULL, options = NULL, printMsg = FALSE) {
    .Call('_ldt_GetRoc', PACKAGE = 'ldt', y, scores, weights, options, printMsg)
}

#' Gets the GLD-FKML Parameters from the moments
#'
#' @description Calculates the parameters of the generalized lambda distribution (FKML), given the first four moments of the distribution.
#'
#' @details
#' The type of the distribution is determined by one or two restrictions:
#' - **type 0:** general
#' - **type 1:** symmetric 'type 0'
#' - **type 2:** uni-modal continuous tail: L3<1 & L4<1
#' - **type 3:** symmetric 'type 2' L3==L4
#' - **type 4:** uni-modal continuous tail finite slope  L3<=0.5 &  L4<=5
#' - **type 5:** symmetric 'type 4' L3==L4
#' - **type 6:** uni-modal truncated density curves: L3>=2 & L4>=2 (includes uniform distribution)
#' - **type 7:** symmetric 'type 6' L3==L4
#' - **type 8:** S shaped L3>2 & 1<L4<2 or 1<L3<2 & L4>2
#' - **type 9:** U shaped 1<L3<=2 and 1<L4<=2
#' - **type 10:** symmetric 'type 9' L4==L4
#' - **type 11:** monotone L3>1 & L4<=1
#'
#' @param mean (double) mean of the distribution.
#' @param variance (double) variance of the distribution.
#' @param skewness (double) skewness of the distribution.
#' @param excessKurtosis (double) excess kurtosis of the distribution.
#' @param type (int) The type of the distribution.
#' @param start (numeric vector, length=2) starting value for L3 and L4. Use null for c(0,0).
#' @param nelderMeadOptions (list) The optimization parameters. Use null for default.
#' @param printMsg (bool) If \code{TRUE}, details are printed.
#'
#' @return a vector with the parameters of the GLD distribution.
#' @export
#'
#' @examples
#' res = GetGldFromMoments(0,1,0,0,0,c(0,0))
GetGldFromMoments <- function(mean = 0, variance = 1, skewness = 0, excessKurtosis = 0, type = 0L, start = NULL, nelderMeadOptions = NULL, printMsg = FALSE) {
    .Call('_ldt_GetGldFromMoments', PACKAGE = 'ldt', mean, variance, skewness, excessKurtosis, type, start, nelderMeadOptions, printMsg)
}

#' Gets GLD Quantile
#'
#' @param data (numeric vector) data
#' @param L1 (double) First parameter
#' @param L2 (double) Second parameter
#' @param L3 (double) Third parameter
#' @param L4 (double) Fourth parameter
#'
#' @return (numeric vector) result
#' @export
GldQuantile <- function(data, L1, L2, L3, L4) {
    .Call('_ldt_GldQuantile', PACKAGE = 'ldt', data, L1, L2, L3, L4)
}

#' Gets GLD Density Quantile
#'
#' @param data (numeric vector) data
#' @param L1 (double) First parameter
#' @param L2 (double) Second parameter
#' @param L3 (double) Third parameter
#' @param L4 (double) Fourth parameter
#'
#' @return (numeric vector) result
#' @export
GldDensityQuantile <- function(data, L1, L2, L3, L4) {
    .Call('_ldt_GldDensityQuantile', PACKAGE = 'ldt', data, L1, L2, L3, L4)
}

#' Combines Two Distributions Defined by their First 4 Moments
#'
#' @param mix1 (list) First distribution which is defined by a list with mean, variance, skewness, kurtosis, sumWeights, count
#' @param mix2 (list) Second distribution (similar to \code{mix1}).
#'
#' @return (list) A list similar to \code{mix1}
#' @export
#'
#' @examples
#' #see its \code{test_that} function
GetCombination4Moments <- function(mix1, mix2) {
    .Call('_ldt_GetCombination4Moments', PACKAGE = 'ldt', mix1, mix2)
}

#' Principle Component Analysis
#'
#' @param x (numeric matrix) data with variables in columns.
#' @param center (bool) if \code{TRUE}, it demeans the variables.
#' @param scale (bool) if \code{TRUE}, it scales the variables to unit variance.
#' @param newX (numeric matrix) data to be used in projection. Its structure must be similar to the \code{x}.
#'
#' @return (list) results
#' \item{removed0Var}{(integer vector) Zero-based indices of removed columns with zero variances.}
#' \item{directions}{(numeric matrix) Directions}
#' \item{stds}{(integer vector) Standard deviation of the principle components}
#' \item{stds2Ratio}{(integer vector) stds^2/sum(stds^2)}
#' \item{projections}{(numeric matrix) Projections if \code{newX} is given.}
#'
#' @export
#'
GetPca <- function(x, center = TRUE, scale = TRUE, newX = NULL) {
    .Call('_ldt_GetPca', PACKAGE = 'ldt', x, center, scale, newX)
}

#' SUR Search
#'
#' @param y (numeric matrix) endogenous data with variables in the columns.
#' @param x (numeric matrix) exogenous data with variables in the columns.
#' @param numTargets (int) determines the number of variable in the first columns of \code{y} for which the information is saved. It must be positive and cannot be larger than the number of endogenous variables.
#' @param xSizes (nullable integer vector) Number of exogenous variables in the regressions. E.g., c(1,2) means the model set contains all the regressions with 1 and 2 exogenous variables. If null, c(1) is used.
#' @param xPartitions (nullable list of integer vector) a partition over the indexes of the exogenous variables. No regression is estimated with two variables in the same group. If \code{NULL}, each variable is placed in its own group and the size of the model set is maximized.
#' @param numFixXPartitions (int) number of partitions at the beginning of \code{xPartitions} to be included in all regressions.
#' @param yGroups (nullable list of integer vector) different combinations of the indexes of the endogenous variables to be used as endogenous variables in the SUR regressions.
#' @param searchSigMaxIter (int) maximum number of iterations in searching for significant coefficients. Use 0 to disable the search.
#' @param searchSigMaxProb (double) maximum value of type I error to be used in searching for significant coefficients. If p-value is less than this, it is interpreted as significant.
#' @param measureOptions (nullable list) see \code{[GetMeasureOptions()]}.
#' @param modelCheckItems (nullable list) see \code{[GetModelCheckItems()]}.
#' @param searchItems (nullable list) see \code{[GetSearchItems()]}.
#' @param searchOptions (nullable list) see \code{[GetSearchOptions()]}.
#'
#' @return A list
#'
#' @export
SurSearch <- function(y, x, numTargets = 1L, xSizes = NULL, xPartitions = NULL, numFixXPartitions = 0L, yGroups = NULL, searchSigMaxIter = 0L, searchSigMaxProb = 0.1, measureOptions = NULL, modelCheckItems = NULL, searchItems = NULL, searchOptions = NULL) {
    .Call('_ldt_SurSearch', PACKAGE = 'ldt', y, x, numTargets, xSizes, xPartitions, numFixXPartitions, yGroups, searchSigMaxIter, searchSigMaxProb, measureOptions, modelCheckItems, searchItems, searchOptions)
}

#' Estimates an SUR Model
#'
#' @param y (numeric matrix) Endogenous data with variables in the columns.
#' @param x (numeric matrix) Exogenous data with variables in the columns.
#' @param addIntercept (bool) If true, intercept is added automatically to x.
#' @param searchSigMaxIter (int) Maximum number of iterations in searching for significant coefficients. Use 0 to disable the search.
#' @param searchSigMaxProb (double) Maximum value of type I error to be used in searching for significant coefficients. If p-value is less than this, it is interpreted as significant and removed in the next iteration (if any exists).
#' @param restriction (nullable numeric matrix) A km x q matrix in which m=ncols(y), k=ncols(x) and q is the number of unrestricted coefficients.
#' @param newX (nullable numeric matrix) Data of new exogenous variables to be used in the predictions. Its columns must be the same as \code{x}. If null, projection is disabled.
#' @param pcaOptionsY (nullable list) A list of options in order to use principal components of the \code{y}, instead of the actual values. Set null to disable. Use \code{[GetPcaOptions()]} for initialization.
#' @param pcaOptionsX (nullable list) Similar to \code{pcaOptionsY} but for \code{x}. see \code{pcaOptionsY}.
#' @param simFixSize (int) Number of pseudo out-of-sample simulations. Use zero to disable the simulation. See also \code{GetMeasureOptions()]}.
#' @param simTrainRatio (double) Size of the training sample as a ratio of the number of the observations. It is effective only if \code{simTrainFixSize} is zero.
#' @param simTrainFixSize (int) A fixed size for the training sample. If zero, \code{simTrainRatio} is used.
#' @param simSeed (int) A seed for the pseudo out-of-sample simulation.
#' @param simMaxConditionNumber (double) Maximum value for the condition number in the simulation.
#' @param printMsg (bool) Set true to enable printing details.
#'
#' @return A list:
#'
#' @export
SurEstim <- function(y, x, addIntercept = TRUE, searchSigMaxIter = 0L, searchSigMaxProb = 0.1, restriction = NULL, newX = NULL, pcaOptionsY = NULL, pcaOptionsX = NULL, simFixSize = 0L, simTrainRatio = 0.75, simTrainFixSize = 0L, simSeed = 0L, simMaxConditionNumber = 1.7e308, printMsg = FALSE) {
    .Call('_ldt_SurEstim', PACKAGE = 'ldt', y, x, addIntercept, searchSigMaxIter, searchSigMaxProb, restriction, newX, pcaOptionsY, pcaOptionsX, simFixSize, simTrainRatio, simTrainFixSize, simSeed, simMaxConditionNumber, printMsg)
}

#' Creates a Variable
#'
#' @param data Data of the variable
#' @param name Name of the variable
#' @param startFrequency Frequency of the first data-point. It is an \code{ldtf} object. See \code{F_?} functions.
#' @param fields Named list of any other fields
#'
#' @return An object of class \code{ldtv}.
#' @export
#' @examples
#' v1 = ldt::Variable(c(1,2,3,2,3,4,5),"V1",F_Monthly(2022,12),
#'      list(c("key1","value1"), c("key2", "value2")))
Variable <- function(data, name, startFrequency, fields) {
    .Call('_ldt_Variable', PACKAGE = 'ldt', data, name, startFrequency, fields)
}

#' Converts a Variable to String
#'
#' @param w The variable
#'
#' @return String representation of the variable in compact form
#' @export
VariableToString <- function(w) {
    .Call('_ldt_VariableToString', PACKAGE = 'ldt', w)
}

#' Binds a List of Variables
#'
#' @param varList A list of variables ((i.e., \code{ldtv} objects)) with similar frequency class
#'
#' @return A matrix with variables in the columns and frequencies as the row names.
#' @export
#' @examples
#' v1 = ldt::Variable(c(1,2,3,2,3,4,5),"V1",F_Monthly(2022,12), list())
#' v2 = ldt::Variable(c(10,20,30,20,30,40,50),"V2",F_Monthly(2022,8), list())
#' vs = ldt::BindVariables(list(v1,v2))
BindVariables <- function(varList) {
    .Call('_ldt_BindVariables', PACKAGE = 'ldt', varList)
}

#' VARMA Search
#'
#' @param y (numeric vector) Endogenous data with variables in the columns.
#' @param x (nullable numeric matrix) Exogenous data with variables in the columns. It can be null.
#' @param numTargets (int) Number of variables in the first columns of \code{y}, regarded as targets. It must be positive and cannot be larger than the number of endogenous variables.
#' @param ySizes (nullable integer vector) Determines the number of endogenous variables (or equations) in the regressions.
#' @param yPartitions (nullable list of int vector) A partition over the indexes of the endogenous variables. No regression is estimated with two variables in the same group. If \code{NULL}, each variable is placed in its own group.
#' @param xGroups (nullable list of int vector) different combinations of the indexes of the exogenous variables to be used as exogenous variables in the SUR regressions.
#' @param maxParams (integer vector, length=6) Maximum values for the parameters of the VARMA model (p,d,q,P,D,Q). If null, c(1,1,1,0,0,0) is used.
#' @param seasonsCount (integer) number of observations per unit of time
#' @param maxHorizon (integer) maximum value for the prediction horizon if \code{type1} is \code{TRUE} in \code{checkItems}. Also, it is used as the maximum prediction horizon in checking the predictions.
#' @param newX (matrix) New exogenous data for out-of-sample prediction. It must have the same number of columns as \code{x}.
#' @param interpolate (logical) if \code{TRUE}, missing observations are interpolated.
#' @param adjustLeadsLags (logical) if \code{TRUE}, leads and lags in the sample are adjusted.
#' @param simUsePreviousEstim (logical) if \code{TRUE}, parameters are initialized in just the first step of the simulation. The initial values of the n-th simulation (with one more observation) is the estimations in the previous step.
#' @param olsStdMultiplier (numeric) a multiplier for the standard deviation of OLS, used for restricting the maximum likelihood estimation.
#' @param lmbfgsOptions (list) Optimization options. see \code{[GetLmbfgsOptions()]}. Use null for default values.
#' @param measureOptions (nullable list) see \code{[GetMeasureOptions()]}.
#' @param modelCheckItems (nullable list) see \code{[GetModelCheckItems()]}.
#' @param searchItems (nullable list) see \code{[GetSearchItems()]}.
#' @param searchOptions (nullable list) see \code{[GetSearchOptions()]}.
#'
#' @return A list
#'
#' @export
VarmaSearch <- function(y, x = NULL, numTargets = 1L, ySizes = NULL, yPartitions = NULL, xGroups = NULL, maxParams = NULL, seasonsCount = 0L, maxHorizon = 0L, newX = NULL, interpolate = TRUE, adjustLeadsLags = TRUE, simUsePreviousEstim = TRUE, olsStdMultiplier = 2.0, lmbfgsOptions = NULL, measureOptions = NULL, modelCheckItems = NULL, searchItems = NULL, searchOptions = NULL) {
    .Call('_ldt_VarmaSearch', PACKAGE = 'ldt', y, x, numTargets, ySizes, yPartitions, xGroups, maxParams, seasonsCount, maxHorizon, newX, interpolate, adjustLeadsLags, simUsePreviousEstim, olsStdMultiplier, lmbfgsOptions, measureOptions, modelCheckItems, searchItems, searchOptions)
}

#' Estimates an VARMA Model
#'
#' @param y (matrix) endogenous data with variables in the columns.
#' @param x (matrix) exogenous data with variables in the columns.
#' @param params (integer vector, length=6) parameters of the VARMA model (p,d,q,P,D,Q).
#' @param seasonsCount (integer) number of observations per unit of time
#' @param addIntercept (logical) if \code{TRUE}, intercept is added automatically to x.
#' @param lmbfgsOptions (list) optimization options. See \code{[GetLmbfgsOptions()]}.
#' @param olsStdMultiplier (numeric) a multiplier for the standard deviation of OLS, used for restricting the maximum likelihood estimation.
#' @param pcaOptionsY (list) a list of options in order to use principal components of the \code{y}, instead of the actual values. set \code{NULL} to disable. Use \code{[GetPcaOptions()]} for initialization.
#' @param pcaOptionsX (list) similar to \code{pcaOptionsY} but for \code{x}. see \code{pcaOptionsY}.
#' @param maxHorizon (integer) maximum prediction horizon. Set zero to disable.
#' @param newX (matrix) data of new exogenous variables to be used in the predictions. Its columns must be the same as \code{x}.
#' @param simFixSize (integer) number of pseudo out-of-sample simulations. Use zero to disable the simulation. see also \code{[GetMeasureOptions()]}.
#' @param simHorizons (integer vector) prediction horizons to be used in pseudo out-of-sample simulations. see also \code{[GetMeasureOptions()]}.
#' @param simUsePreviousEstim (logical) if \code{TRUE}, parameters are initialized in just the first step of the simulation. The initial values of the n-th simulation (with one more observation) is the estimations in the previous step.
#' @param simMaxConditionNumber (numeric) maximum value for the condition number in the pseudo out-of-sample simulations.
#' @param printMsg (logical) set \code{FALSE} to disable printing the details.
#'
#' @return A list:
#'
#' @export
VarmaEstim <- function(y, x = NULL, params = NULL, seasonsCount = 0L, addIntercept = TRUE, lmbfgsOptions = NULL, olsStdMultiplier = 2, pcaOptionsY = NULL, pcaOptionsX = NULL, maxHorizon = 0L, newX = NULL, simFixSize = 0L, simHorizons = NULL, simUsePreviousEstim = TRUE, simMaxConditionNumber = 1e20, printMsg = FALSE) {
    .Call('_ldt_VarmaEstim', PACKAGE = 'ldt', y, x, params, seasonsCount, addIntercept, lmbfgsOptions, olsStdMultiplier, pcaOptionsY, pcaOptionsX, maxHorizon, newX, simFixSize, simHorizons, simUsePreviousEstim, simMaxConditionNumber, printMsg)
}

