% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legend.R
\name{addLegendImage}
\alias{addLegendImage}
\title{Add a Legend with Images}
\usage{
addLegendImage(
  map,
  images,
  labels,
  title = "",
  labelStyle = "font-size: 24px; vertical-align: middle;",
  orientation = c("vertical", "horizontal"),
  width = 20,
  height = 20,
  group = NULL,
  className = "info legend leaflet-control",
  ...
)
}
\arguments{
\item{map}{a map widget object created from 'leaflet'}

\item{images}{path to the image file}

\item{labels}{labels for each image}

\item{title}{the legend title, pass in HTML to style}

\item{labelStyle}{character string of style argument for HTML text}

\item{orientation}{stack the legend items vertically or horizontally}

\item{width}{in pixels}

\item{height}{in pixels}

\item{group}{group name of a leaflet layer group}

\item{className}{extra CSS class to append to the control, space separated}

\item{...}{arguments to pass to \link[leaflet]{addControl}}
}
\value{
an object from \link[leaflet]{addControl}
}
\description{
Creates a legend with images that are embedded into a 'leaflet' map so that
images do not need to be packaged when saving a 'leaflet' map as HTML. Full
control over the label and title style. The 'leaflet' map is passed through
and the output is a control so that legend is fully integrated with other
functionalities.
}
\examples{

library(leaflet)
data(quakes)

quakes1 <- quakes[1:10,]

leafIcons <- icons(
  iconUrl = ifelse(quakes1$mag < 4.6,
                   "http://leafletjs.com/examples/custom-icons/leaf-green.png",
                   "http://leafletjs.com/examples/custom-icons/leaf-red.png"
  ),
  iconWidth = 38, iconHeight = 95,
  iconAnchorX = 22, iconAnchorY = 94,
  shadowUrl = "http://leafletjs.com/examples/custom-icons/leaf-shadow.png",
  shadowWidth = 50, shadowHeight = 64,
  shadowAnchorX = 4, shadowAnchorY = 62
)

leaflet(data = quakes1) \%>\% addTiles() \%>\%
  addMarkers(~long, ~lat, icon = leafIcons, group = 'Quake Leaves') \%>\%
  addLegendImage(images = c("http://leafletjs.com/examples/custom-icons/leaf-green.png",
                            "http://leafletjs.com/examples/custom-icons/leaf-red.png"),
                 labels = c('Green', 'Red'),width = 38, height = 95,
                 title = htmltools::tags$div('Leaf',
                 style = 'font-size: 24px; text-align: center;'),
                 position = 'topright',
                 group = 'Quake Leaves') \%>\%
  addLayersControl(overlayGroups = c('Quake Leaves'), position = 'bottomright')

 # use raster images with size encodings
 height <- sizeNumeric(quakes$depth, baseSize = 40)
 width <- height * 38 / 95
 symbols <- icons(
   iconUrl = 'http://leafletjs.com/examples/custom-icons/leaf-green.png',
   iconWidth = width,
   iconHeight = height)
 probs <- c(.2, .4, .6, .8)
 leaflet(quakes) \%>\%
   addTiles() \%>\%
   addMarkers(icon = symbols,
              lat = ~lat, lng = ~long) \%>\%
   addLegendImage(
     images = rep("http://leafletjs.com/examples/custom-icons/leaf-green.png", 4),
     labels = round(quantile(height, probs = probs), 0),
     width = quantile(height, probs = probs) * 38 / 95,
     height = quantile(height, probs = probs),
     title = htmltools::tags$div(
       'Leaf',
       style = 'font-size: 24px; text-align: center; margin-bottom: 5px;'),
     position = 'topright', orientation = 'vertical')
}
