% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pulseIcon.R
\name{pulseIconList}
\alias{pulseIconList}
\alias{[.leaflet_pulse_icon_set}
\alias{makePulseIcon}
\alias{pulseIcons}
\alias{addPulseMarkers}
\title{Make pulse-icon set}
\usage{
pulseIconList(...)

\method{[}{leaflet_pulse_icon_set}(x, i)

makePulseIcon(color = "#ff0000", iconSize = 12, animate = TRUE, heartbeat = 1)

pulseIcons(color = "#ff0000", iconSize = 12, animate = TRUE, heartbeat = 1)

addPulseMarkers(
  map,
  lng = NULL,
  lat = NULL,
  layerId = NULL,
  group = NULL,
  icon = NULL,
  popup = NULL,
  popupOptions = NULL,
  label = NULL,
  labelOptions = NULL,
  options = leaflet::markerOptions(),
  clusterOptions = NULL,
  clusterId = NULL,
  data = leaflet::getMapData(map)
)
}
\arguments{
\item{...}{icons created from \code{\link{makePulseIcon}()}}

\item{x}{icons}

\item{i}{offset}

\item{color}{Color of the icon}

\item{iconSize}{Size of Icon in Pixels.}

\item{animate}{To animate the icon or not, defaults to TRUE.}

\item{heartbeat}{Interval between each pulse in seconds.}

\item{map}{a map widget object created from \code{\link[leaflet:leaflet]{leaflet()}}}

\item{lng}{a numeric vector of longitudes, or a one-sided formula of the form
\code{~x} where \code{x} is a variable in \code{data}; by default (if not
explicitly provided), it will be automatically inferred from \code{data} by
looking for a column named \code{lng}, \code{long}, or \code{longitude}
(case-insensitively)}

\item{lat}{a vector of latitudes or a formula (similar to the \code{lng}
argument; the names \code{lat} and \code{latitude} are used when guessing
the latitude column from \code{data})}

\item{layerId}{the layer id}

\item{group}{the name of the group the newly created layers should belong to
(for \code{\link[leaflet:clearGroup]{clearGroup()}} and \code{\link[leaflet:addLayersControl]{addLayersControl()}} purposes).
Human-friendly group names are permitted--they need not be short,
identifier-style names. Any number of layers and even different types of
layers (e.g. markers and polygons) can share the same group name.}

\item{icon}{the icon(s) for markers; an icon is represented by an R list of
the form \code{list(iconUrl = "?", iconSize = c(x, y))}, and you can use
\code{\link[leaflet:icons]{icons()}} to create multiple icons; note when you use an R list
that contains images as local files, these local image files will be base64
encoded into the HTML page so the icon images will still be available even
when you publish the map elsewhere}

\item{popup}{a character vector of the HTML content for the popups (you are
recommended to escape the text using \code{\link[htmltools:htmlEscape]{htmltools::htmlEscape()}}
for security reasons)}

\item{popupOptions}{A Vector of \code{\link[leaflet:popupOptions]{popupOptions()}} to provide popups}

\item{label}{a character vector of the HTML content for the labels}

\item{labelOptions}{A Vector of \code{\link[leaflet:labelOptions]{labelOptions()}} to provide label
options for each label. Default \code{NULL}}

\item{options}{a list of extra options for tile layers, popups, paths
(circles, rectangles, polygons, ...), or other map elements}

\item{clusterOptions}{if not \code{NULL}, markers will be clustered using
\href{https://github.com/Leaflet/Leaflet.markercluster}{Leaflet.markercluster};
you can use \code{\link[leaflet:markerClusterOptions]{markerClusterOptions()}} to specify marker cluster
options}

\item{clusterId}{the id for the marker cluster layer}

\item{data}{the data object from which the argument values are derived; by
default, it is the \code{data} object provided to \code{leaflet()}
initially, but can be overridden}
}
\description{
An icon can be represented as a list of the form \code{list(color, iconSize,
...)}. This function is vectorized over its arguments to create a list of
icon data. Shorter argument values will be re-cycled. \code{NULL} values for
these arguments will be ignored.
}
\examples{

iconSet <- pulseIconList(
  red = makePulseIcon(color = "#ff0000"),
  blue = makePulseIcon(color = "#0000ff")
)

iconSet[c("red", "blue")]

leaflet() \%>\%
  addTiles() \%>\%
  addPulseMarkers(
    lng = -118.456554, lat = 34.078039,
    label = "This is a label",
    icon = makePulseIcon(heartbeat = 0.5)
  )


## for more examples see
# browseURL(system.file("examples/pulseIcon.R", package = "leaflet.extras"))
}
