% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wms-legend.R
\name{addWMSLegend}
\alias{addWMSLegend}
\title{Add WMS Legend}
\usage{
addWMSLegend(map, uri, position = "topright", layerId = NULL, group = NULL)
}
\arguments{
\item{map}{a map widget object created from \code{\link[leaflet:leaflet]{leaflet()}}}

\item{uri}{The legend URI}

\item{position}{the position of the legend}

\item{layerId}{When the layerId of the WMS layer is properly set, the legend
will appear or disappear accordingly based on whether the layer is visible or not.
If no layerId is given, it will try to get the layer name from the `uri`,
otherwise a random ID will be assigned.}

\item{group}{The group argument is not used. Please set the `layerId` correctly.}
}
\description{
Add a WMS Legend
}
\examples{
leaflet() \%>\%
  addTiles() \%>\%
  setView(11, 51, 6) \%>\%
  addWMSTiles(
    baseUrl = "https://www.wms.nrw.de/wms/unfallatlas?request=GetMap",
    layers = c("Unfallorte", "Personenschaden_5000", "Personenschaden_250"),
    options = WMSTileOptions(format = "image/png", transparent = TRUE)
  ) \%>\%
  addWMSLegend(
    uri = paste0(
      "https://www.wms.nrw.de/wms/unfallatlas?request=",
      "GetLegendGraphic&version=1.3.0&",
      "format=image/png&layer=Personenschaden_5000"
    )
  )
}
