% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contextmenu.R
\name{addContextmenu}
\alias{addContextmenu}
\title{Add contextmenu Plugin}
\usage{
addContextmenu(map)
}
\arguments{
\item{map}{a map widget object created from \code{\link[leaflet]{leaflet}}}
}
\value{
A leaflet map object
}
\description{
Add a contextmenu to the map or markers/vector layers.
}
\details{
This function is only used to include the required JavaScript and CSS
bindings and to set up some Shiny event handlers.

\subsection{Contextmenu initialization}{
The contextmenu for
\itemize{
 \item {the \strong{map} must be defined in \code{\link[leaflet]{leafletOptions}}.}
 \item {the \strong{markers/vector layers} must be defined in \code{\link[leaflet]{markerOptions}}
        or \code{\link[leaflet]{pathOptions}}.}
}
}

\subsection{Contextmenu selection}{
When a contextmenu is selected, a Shiny input with the ID \code{"MAPID_contextmenu_select"}
is set (`MAPID` refers to the map's id).

If the selected contextmenu item is triggered from:
\itemize{
  \item {the \strong{map}, the returned list containts the \code{text} of the item.}
  \item {the \strong{markers}, the returned list also contains the
         \code{layerId}, \code{group}, \code{lat}, \code{lng} and \code{label}.}
  \item {the \strong{vector layers}, the returned list also contains the
         \code{layerId}, \code{group} and \code{label}.}
}
}
}
\examples{
library(leaflet)
leaflet(options = leafletOptions(
    contextmenu = TRUE,
    contextmenuWidth = 200,
    contextmenuItems =
     mapmenuItems(
       menuItem("Zoom Out", "function(e) {this.zoomOut()}", disabled=FALSE),
       "-",
       menuItem("Zoom In", "function(e) {this.zoomIn()}")))) \%>\%
  addTiles(group = "base") \%>\%
  addContextmenu() \%>\%
  addMarkers(data = breweries91, label = ~brewery,
          layerId = ~founded, group = "marker",
          options = markerOptions(
            contextmenu = TRUE,
            contextmenuWidth = 200,
            contextmenuItems =
              markermenuItems(
                menuItem(text = "Show Marker Coords",
                         callback = "function(e) {alert(e.latlng);}",
                         index = 1)
              )
          ))

}
\references{
\url{https://github.com/aratcliffe/Leaflet.contextmenu}
}
\seealso{
Other Contextmenu Functions: 
\code{\link{addItemContextmenu}()},
\code{\link{hideContextmenu}()},
\code{\link{insertItemContextmenu}()},
\code{\link{mapmenuItems}()},
\code{\link{markermenuItems}()},
\code{\link{menuItem}()},
\code{\link{removeItemContextmenu}()},
\code{\link{removeallItemsContextmenu}()},
\code{\link{setDisabledContextmenu}()},
\code{\link{showContextmenu}()}
}
\concept{Contextmenu Functions}
