% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixcreation.R
\name{summary.lefkoMat}
\alias{summary.lefkoMat}
\title{Summary of class "lefkoMat"}
\usage{
\method{summary}{lefkoMat}(object, ...)
}
\arguments{
\item{object}{An object of class \code{lefkoMat}.}

\item{...}{Other parameters.}
}
\value{
A summary of the object, showing the number of each type of matrix, the
number of annual matrices, the number of estimated (non-zero) elements across
all matrices and per matrix, the number of unique transitions in the dataset,
and the number of individuals.
}
\description{
A function to simplify the viewing of basic information describing the matrices
produced through functions \code{\link{flefko3}()}, \code{\link{flefko2}()}, \code{\link{rlefko3}()},
and \code{\link{rlefko2}()}.
}
\examples{
data(cypdata)

sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", 
                 "Sm", "Md", "Lg", "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
                          repstatus = repvector, obsstatus = obsvector,
                          matstatus = matvector, propstatus = propvector,
                          immstatus = immvector, indataset = indataset,
                          binhalfwidth = binvec)

cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
                          patchidcol = "patch", individcol = "plantid",
                          blocksize = 4, size1col = "Inf2.04", size2col = "Inf.04",
                          size3col = "Veg.04", repstr1col = "Inf.04",
                          repstr2col = "Inf2.04", fec1col = "Pod.04",
                          stageassign = cypframe_raw, stagesize = "sizeadded",
                          NAas0 = TRUE, NRasRep = TRUE)

rep_cyp_raw <- matrix(0, 11, 11)
rep_cyp_raw[1:2,7:11] <- 0.5

cypover2r <- overwrite(stage3 = c("SD", "P1", "P2", "P3", "D", "XSm", "Sm", "SL", "SL"),
                       stage2 = c("SD", "SD", "P1", "P2", "P3", "P3", "P3", "P3", "SL"),
                       eststage3 = c(NA, NA, NA, NA, "D", "XSm", "Sm", NA, NA),
                       eststage2 = c(NA, NA, NA, NA, "D", "D", "D", NA, NA),
                       givenrate = c(0.1, 0.2, 0.2, 0.2, NA, NA, NA, 0.25, 0.4),
                       type = c("S", "S", "S", "S", "S", "S", "S", "S", "S"))

cypmatrix2r <- rlefko2(data = cypraw_v1, stageframe = cypframe_raw, year = "all",
                       patch = "all", stages = c("stage3", "stage2", "stage1"),
                       size = c("size3added", "size2added"),
                       repmatrix = rep_cyp_raw, overwrite = cypover2r,
                       yearcol = "year2", patchcol = "patchid",
                       indivcol = "individ")
summary(cypmatrix2r)

}
