% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_portrait.R
\name{get_portrait}
\alias{get_portrait}
\title{Fetch 'Portrait' table}
\format{Data frame with columns (varies by legislature):
\itemize{
\item{pageid: Wikipedia page ID identifying a legislator's Wikipedia biography (of class \sQuote{integer}).}
\item{image_url: URL linking to a legislator's portrait on Wikimedia Commons (of class \sQuote{character}).}
}}
\source{
Wikipedia API, \url{https://wikipedia.org/w/api.php} \cr
Wikimedia Commons, \url{https://commons.wikimedia.org/}
}
\usage{
get_portrait(legislature)
}
\arguments{
\item{legislature}{A character string specifying the three-letter country code of the legislature for which data shall be fetched. Currently one of \sQuote{aut}, \sQuote{can}, \sQuote{cze}, \sQuote{esp}, \sQuote{fra}, \sQuote{deu}, \sQuote{irl}, \sQuote{sco}, \sQuote{gbr}, \sQuote{usa_house}, or \sQuote{usa_senate}.}
}
\value{
A data frame with columns as specified above.
}
\description{
Fetches portrait urls of legislators for the specified legislature. Requires a working Internet connection.
}
\examples{
\donttest{# Get entire 'Portraits' table for the United States Senate
usa_portraits <- get_portrait(legislature = "usa_senate")
tibble::glimpse(usa_portraits)

# Get 'Portraits' table for Democratic members of the United States Senate
usa_port_subset <- dplyr::semi_join(x = usa_portraits,
                                    y = dplyr::filter(get_political(legislature = "usa_senate"),
                                                                    party == "D"),
                                    by = "pageid")
tibble::glimpse(usa_port_subset)
}
}
