% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legends.r
\name{grid_arrange_shared_legend}
\alias{grid_arrange_shared_legend}
\title{Share a legend between multiple plots}
\usage{
grid_arrange_shared_legend(..., ncol = length(list(...)), nrow = 1,
  position = c("bottom", "right", "top", "left"), plot = TRUE)
}
\arguments{
\item{...}{ggplot2 objects. Their legends are automatically hidden.
The legend is taken from the first argument.}

\item{ncol}{Integer, number of columns to arrange plots in.}

\item{nrow}{Integer, number of rows to arrange plots in.}

\item{position}{'bottom' or 'right' for positioning legend.}

\item{plot}{Logical, when \code{TRUE} (default), draws combined plot on a
new page.}
}
\value{
gtable of combined plot, invisibly. 
  Draw  gtable object using \code{\link[grid]{grid.draw}}.
}
\description{
Extract legend, combines plots using \code{\link[gridExtra]{arrangeGrob}},
and places legend in a margin.
}
\examples{
library(ggplot2)
dsamp <- diamonds[sample(nrow(diamonds), 1000), ]
p1 <- qplot(carat, price, data = dsamp, colour = clarity)
p2 <- qplot(cut, price, data = dsamp, colour = clarity)
p3 <- qplot(color, price, data = dsamp, colour = clarity)
p4 <- qplot(depth, price, data = dsamp, colour = clarity)
grid_arrange_shared_legend(p1, p2, p3, p4, ncol = 4, nrow = 1)
grid_arrange_shared_legend(p1, p2, p3, p4, ncol = 2, nrow = 2)
}
\seealso{
\code{\link{g_legend}}, \code{\link{reposition_legend}}
}
\author{
Originally brought to you by \href{http://rpubs.com/sjackman}{Shaun Jackman}
  (\href{http://rpubs.com/sjackman/grid_arrange_shared_legend}{original}),
  and further improved by \href{http://baptiste.github.io/}{Baptiste Auguié}  at
  \url{https://github.com/tidyverse/ggplot2/wiki/Share-a-legend-between-two-ggplot2-graphs}.
  Stefan McKinnon Edwards added left and top margins.
}
