% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsets.R
\name{cbind.fsets}
\alias{cbind.fsets}
\title{Combine several 'fsets' objects into a single one}
\usage{
\method{cbind}{fsets}(..., deparse.level = 1, warn = TRUE)
}
\arguments{
\item{...}{A sequence of objects of class 'fsets' to be merged by columns.}

\item{deparse.level}{This argument has currently no function and is added
here only for compatibility with generic \code{\link[=cbind]{cbind()}} function.}

\item{warn}{Whether to issue warning when combining two fsets having the same vars
about the fact that specs may not be accurate}
}
\value{
An object of class 'fsets' that is created by merging the arguments
by columns.  Also the arguments' attributes \code{\link[=vars]{vars()}} and \code{\link[=specs]{specs()}} are merged together.
}
\description{
Take a sequence of objects of class 'fsets' and combine them by columns.
This version of cbind takes care of the \code{\link[=vars]{vars()}} and \code{\link[=specs]{specs()}}
attributes of the arguments and merges them to the result. If some argument
does not inherit from the 'fsets' class, an error is thrown.
}
\details{
The \code{\link[=vars]{vars()}} attribute is merged by concatenating the \code{\link[=vars]{vars()}} attributes
of each argument. Also the \code{\link[=specs]{specs()}} attributes of the arguments are merged together.
}
\examples{
    d1 <- fcut(CO2[, 1:2])
    d2 <- fcut(CO2[, 3:4], breaks=list(conc=1:4*1000/4))
    r <- cbind(d1, d2)

    print(colnames(d1))
    print(colnames(d2))
    print(colnames(r))

    print(vars(d1))
    print(vars(d2))
    print(vars(r))

    print(specs(d1))
    print(specs(d2))
    print(specs(r))

}
\seealso{
\code{\link[=vars]{vars()}}, \code{\link[=specs]{specs()}}, \code{\link[=fcut]{fcut()}}, \code{\link[=lcut]{lcut()}}
}
\author{
Michal Burda
}
\keyword{models}
\keyword{robust}
