\name{blockcircbaseFunction}
\alias{blockcircbaseFunction}
\title{blockcircbaseFunction function}
\usage{
  blockcircbaseFunction(x, y, CovFunction, CovParameters,
    inverse = FALSE)
}
\arguments{
  \item{x}{x centroids, an equally spaced vector}

  \item{y}{y centroids, an equally spaced vector}

  \item{CovFunction}{a function of distance, returning the
  covariance between points that distance apart}

  \item{CovParameters}{an object of class CovParamters, see
  ?CovParameters}

  \item{inverse}{logical. Whether to return the base matrix
  of the inverse covariance matrix (ie the base matrix for
  the precision matrix), default is FALSE}
}
\value{
  the base matrix of a block circulant matrix representing
  a stationary covariance function on a toral grid.
}
\description{
  Compute the base matrix of a continuous Gaussian field.
  Computed as a block circulant matrix on a torus where x
  and y is the x and y centroids (must be equally spaced).
  This is an extension of the function blockcircbase to
  extend the range of covariance functions that can be
  fitted to the model.
}
\seealso{
  \link{minimum.contrast},
  \link{minimum.contrast.spatiotemporal},
  \link{chooseCellwidth}, \link{getpolyol},
  \link{guessinterp}, \link{getZmat},
  \link{addTemporalCovariates}, \link{lgcpPrior},
  \link{lgcpInits}, \link{lgcpPredictSpatialPlusPars},
  \link{lgcpPredictAggregateSpatialPlusPars},
  \link{lgcpPredictSpatioTemporalPlusPars},
  \link{lgcpPredictMultitypeSpatialPlusPars}
}

