% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Appender.R
\name{AppenderDbi}
\alias{AppenderDbi}
\title{Log to databases via DBI}
\description{
Log to a database table with any \strong{DBI} compatible backend. Please be
aware that AppenderDbi does \emph{not} support case sensitive / quoted column
names, and you advised to only use all-lowercase names for
custom fields (see \code{...} argument of \link{LogEvent}).
When appending to a database table all LogEvent values for which a column
exists in the target table will be appended, all others are ignored.
}
\section{Buffered Logging}{


AppenderDbi does not write directly to the database but to an in memory
buffer. With the default settings, this buffer is written to the database
whenever the buffer is full (\code{buffer_size}, default is 10 LogEvents),
whenever a LogEvent with a level of \code{fatal} or \code{error} is encountered
(\code{flush_threshold}) or when the Appender is garbage collected
(\code{flush_on_exit}), i.e. when you close the \R session or shortly after you
remove the Appender object via \code{rm()}. If you want to disable buffering, just
set \code{buffer_size} to \code{0}.
}

\section{Usage}{
\preformatted{
x <- AppenderDbi$new(conn, table, threshold = NA_integer_, layout =
  select_dbi_layout(conn, table), close_on_exit = TRUE, buffer_size = 10,
  flush_threshold = "error", flush_on_exit = TRUE, flush_on_rotate = TRUE,
  should_flush = default_should_flush, filters = NULL)

x$add_filter(filter, name = NULL)
x$append(event)
x$filter(event)
x$flush()
x$format(color = FALSE, ...)
x$remove_filter(pos)
x$set_buffer_size(x)
x$set_close_on_exit(x)
x$set_conn(conn)
x$set_filters(filters)
x$set_flush_on_exit(x)
x$set_flush_on_rotate(x)
x$set_flush_threshold(level)
x$set_layout(layout)
x$set_should_flush(x)
x$set_threshold(level)
x$show(threshold = NA_integer_, n = 20)
x$show(threshold = NA_integer_, n = 20L)

x$buffer_df
x$buffer_dt
x$buffer_events
x$buffer_size
x$close_on_exit
x$col_types
x$conn
x$data
x$destination
x$dt
x$filters
x$flush_on_exit
x$flush_on_rotate
x$flush_threshold
x$layout
x$should_flush
x$table
x$table_id
x$table_name
x$threshold

}
}

\section{Creating a New Appender}{


An AppenderDbi is linked to a database table via its \code{table} argument. If
the table does not exist it is created either when the Appender is first
instantiated or (more likely) when the first LogEvent would be written to
that table. Rather than to rely on this feature, it is recommended that you
create the target log table first manually using an \code{SQL CREATE TABLE}
statement as this is safer and more flexible. See also \link{LayoutDbi}.



New Appenders are instantiated with \code{<AppenderSubclass>$new()}. For the
arguments to \code{new()} please refer to the section \emph{Fields}. You can also
modify those fields after the Appender has been created with setters in the
form of \code{appender$set_<fieldname>(value)}
}

\section{Fields}{


Note: \code{$data} and \code{show()} query the data from the remote database and might
be slow for very large logs.

\describe{
\item{\code{close_on_exit}, \code{set_close_on_exit()}}{\code{TRUE} or \code{FALSE}. Close the
Database connection when the Logger is removed?}
\item{\code{conn}, \code{set_conn(conn)}}{a \link[DBI:dbConnect]{DBI connection}}
\item{\code{table}}{Name of the target database table}
}



\describe{
\item{\code{buffer_size, set_buffer_size(x)}}{\code{integer} scalar \code{>= 0} Number of
\link{LogEvents} to buffer.
}

\item{\code{buffer_events}, \code{buffer_df}, \code{buffer_dt}}{
The contents of the buffer as a \code{list} of \link[=LogEvent]{LogEvents}, a
\code{data.frame} or a \code{data.table}.
}

\item{\code{flush_threshold}, \code{set_flush_threshold()}}{\code{integer} or \code{character}
\link[=log_level]{log level}. Minimum event level that will trigger flushing of
the buffer. This behaviour is implemented through \code{should_flush()},
and you can modify that function for different behaviour.
}
\item{\code{should_flush(event)}, \code{set_should_flush(x)}}{
A function with exactly one arguments: \code{event}.
If the function returns \code{TRUE}, flushing of the buffer
is triggered. Defaults to flushing if an event of level \code{error}
or higher is registered.}
}



\describe{
\item{\code{dt}}{Get the log recorded by this \code{Appender} as a \code{data.table}
with a maximum of \code{buffer_size} rows}
}



\describe{
\item{\code{data}}{Get the log recorded by this \code{Appender} as a \code{data.frame}}
}



\describe{
\item{\code{threshold}, \code{set_threshold(level)}}{\code{character} or \code{integer} scalar.
The minimum log level that triggers this logger. See \link{log_levels}}
\item{\code{layout}, \code{set_layout(layout)}}{a \code{Layout} that will be used for
formatting the \code{LogEvents} passed to this Appender}
\item{\code{destination}}{The output destination of the \code{Appender} in
human-readable form (mainly for print output)}
}



\describe{
\item{\code{filters}, \code{set_filters(filters)}}{a \code{list} that may contain
\code{functions} or any \R object with a \code{filter()} method. These functions
must have exactly one argument: \code{event} which will get passed the
LogEvent when the Filterable's \code{filter()} method is invoked.
If all of these functions evaluate to \code{TRUE} the LogEvent is passed on.
Since LogEvents have reference semantics, filters can also be abused to
modify them before they are passed on. Look at the source code of
\code{\link[=with_log_level]{with_log_level()}} or \code{\link[=with_log_value]{with_log_value()}} for examples.
}
}
}

\section{Choosing the Right DBI Layout}{


Layouts for relational database tables are tricky as they have very strict
column types and further restrictions. On top of that implementation details
vary between database backends.

To make setting up \code{AppenderDbi} as painless as possible, the helper function
\code{\link[=select_dbi_layout]{select_dbi_layout()}} tries to automatically determine sensible \link{LayoutDbi}
settings based on \code{conn} and - if it exists in the database already -
\code{table}. If \code{table} does not exist in the database and you start logging, a
new table will be created with the \code{col_types} from \code{layout}.
}

\section{Methods}{


\describe{
\item{\code{flush()}}{Manually trigger flushing of the buffer}
}


\describe{
\item{\code{show(n, threshold)}}{Show the last \code{n} log entries with a log level
bellow \code{threshold}. The log entries will be formatted for console output
via this Appenders \link{Layout}}
}


\describe{
\item{\code{append(event)}}{Tell the Appender to process a \link{LogEvent} \code{event}.
This method is usually not called by the user, but invoked by a
\link{Logger}
}
}


\describe{
\item{\code{filter(event)}}{Determine whether the LogEvent \code{x} should be passed
on to Appenders (\code{TRUE}) or not (\code{FALSE}). See also the active binding
\code{filters}}
\item{\code{add_filter(filter, name = NULL)}, \code{remove_filter(pos)}}{
Add or remove a filter. When adding a filter an optional \code{name} can
be specified. \code{remove_filter()} can remove by position or name (if one
was specified)
}
}
}

\seealso{
Other Appenders: \code{\link{AppenderBuffer}},
  \code{\link{AppenderConsole}},
  \code{\link{AppenderFileRotating}},
  \code{\link{AppenderFile}}, \code{\link{AppenderGmail}},
  \code{\link{AppenderJson}},
  \code{\link{AppenderPushbullet}},
  \code{\link{AppenderRjdbc}},
  \code{\link{AppenderSendmail}},
  \code{\link{AppenderSyslog}},
  \code{\link{AppenderTable}}, \code{\link{Appender}}
}
\concept{Appenders}
