% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger_tree.R
\name{logger_tree}
\alias{logger_tree}
\title{Logger Tree}
\usage{
logger_tree()
}
\value{
\code{data.frame} with subclass \code{"logger_tree"}
}
\description{
Displays a tree structure of all registered Loggers.
}
\section{Symbology}{

\itemize{
\item unconfigured Loggers are displayed in gray (if your terminal supports
colors and you have the package \pkg{crayon} installed).
\item If a logger's \code{threshold} is set, it is displayed in square brackets next
to its name (reminder: if the threshold is not set, it is inherited from
next logger up the logger tree).
\item If a logger's \code{propagate} field is set to \code{FALSE} an red hash (\code{#}) sign
is displayed in front of the logger name, to imply that it does not pass
LogEvents up the tree.
}
}

\examples{
get_logger("fancymodel")
get_logger("fancymodel/shiny")$
  set_propagate(FALSE)

get_logger("fancymodel/shiny/ui")$
  set_appenders(AppenderConsole$new())

get_logger("fancymodel/shiny/server")$
  set_appenders(list(AppenderConsole$new(), AppenderConsole$new()))$
  set_threshold("trace")

get_logger("fancymodel/plumber")

if (requireNamespace("cli")){
  print(logger_tree())
}

}
