% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libproj-install-proj-data.R
\name{libproj_install_proj_data}
\alias{libproj_install_proj_data}
\alias{libproj_has_proj_data}
\title{Download and install PROJ data files}
\usage{
libproj_install_proj_data(
  where = libproj_default_data_dir(),
  overwrite = NA,
  quiet = FALSE
)

libproj_has_proj_data(where = libproj_default_data_dir())
}
\arguments{
\item{where}{The directory into which data files will be installed.}

\item{overwrite}{Use \code{NA} to overwrite if newer or \code{TRUE} to overwrite
completely.}

\item{quiet}{Use \code{TRUE} to suppress status messages}
}
\value{
\code{TRUE} if files were downloaded and installed, \code{FALSE} otherwise
}
\description{
Since PROJ 7.0, the data files used to convert between horizontal and vertical datums
are packaged separately. You can access these files as needed using the PROJ
networking capability (e.g., with \code{libproj_configure(network_enabled = TRUE)}) or
you can download them all at once. This function searches for the latest release
from the \href{https://github.com/OSGeo/PROJ-data}{PROJ-data}.
}
\examples{
# will download ~600 MB!
\dontrun{
libproj_install_proj_data()
}

}
