% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libname.R
\name{lib_path}
\alias{lib_path}
\title{Get the Path for a Data Library}
\usage{
lib_path(x)
}
\arguments{
\item{x}{The data library.}
}
\value{
The path of the data library as a single string.
}
\description{
The \code{lib_path} function returns the current path of the 
the library as a string.
}
\examples{
# Create temp directory
tmp <- tempdir()

# Create library
libname(dat, tmp)

# Examine library path
lib_path(dat)
# [1] "C:\\Users\\User\\AppData\\Local\\Temp\\RtmpCSJ6Gc"

# Clean up
lib_delete(dat)
}
\seealso{
Other lib: 
\code{\link{is.lib}()},
\code{\link{lib_add}()},
\code{\link{lib_copy}()},
\code{\link{lib_delete}()},
\code{\link{lib_info}()},
\code{\link{lib_load}()},
\code{\link{lib_remove}()},
\code{\link{lib_replace}()},
\code{\link{lib_size}()},
\code{\link{lib_sync}()},
\code{\link{lib_unload}()},
\code{\link{lib_write}()},
\code{\link{libname}()},
\code{\link{print.lib}()}
}
\concept{lib}
