/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#include <string.h>
#include <libxml/xmlwriter.h>
#include <pharmml/common_types.h>
#include <pharmml/string.h>
#include <so/OptimalDesignBlock.h>
#include <so/private/OptimalDesignBlock.h>

so_OptimalDesignBlock *so_OptimalDesignBlock_new()
{
	so_OptimalDesignBlock *object = calloc(sizeof(so_OptimalDesignBlock), 1);
	if (object) {
		object->reference_count = 1;
	}

	return object;
}

so_OptimalDesignBlock *so_OptimalDesignBlock_copy(so_OptimalDesignBlock *self)
{
	so_OptimalDesignBlock *dest = so_OptimalDesignBlock_new();
	if (dest) {
		if (self->blockNumber) {
			dest->blockNumber_number = self->blockNumber_number;
			dest->blockNumber = &(dest->blockNumber_number);
		}
		if (self->FIM) {
			dest->FIM = so_Matrix_copy(self->FIM);
			if (!dest->FIM) {
				so_OptimalDesignBlock_free(dest);
				return NULL;
			}
		}
		if (self->CovarianceMatrix) {
			dest->CovarianceMatrix = so_Matrix_copy(self->CovarianceMatrix);
			if (!dest->CovarianceMatrix) {
				so_OptimalDesignBlock_free(dest);
				return NULL;
			}
		}
		if (self->ParameterPrecision) {
			dest->ParameterPrecision = so_Table_copy(self->ParameterPrecision);
			if (!dest->ParameterPrecision) {
				so_OptimalDesignBlock_free(dest);
				return NULL;
			}
		}
		if (self->Criteria) {
			dest->Criteria = so_Table_copy(self->Criteria);
			if (!dest->Criteria) {
				so_OptimalDesignBlock_free(dest);
				return NULL;
			}
		}
		if (self->Tests) {
			dest->Tests = so_Table_copy(self->Tests);
			if (!dest->Tests) {
				so_OptimalDesignBlock_free(dest);
				return NULL;
			}
		}
		if (self->SimulatedData) {
			dest->SimulatedData = so_ExternalFile_copy(self->SimulatedData);
			if (!dest->SimulatedData) {
				so_OptimalDesignBlock_free(dest);
				return NULL;
			}
		}
		if (self->Design) {
			dest->Design = so_ExternalFile_copy(self->Design);
			if (!dest->Design) {
				so_OptimalDesignBlock_free(dest);
				return NULL;
			}
		}
	}

	return dest;
}

void so_OptimalDesignBlock_free(so_OptimalDesignBlock *self)
{
	if (self) {
		so_Matrix_unref(self->FIM);
		so_Matrix_unref(self->CovarianceMatrix);
		so_Table_unref(self->ParameterPrecision);
		so_Table_unref(self->Criteria);
		so_Table_unref(self->Tests);
		so_ExternalFile_unref(self->SimulatedData);
		so_ExternalFile_unref(self->Design);
		free(self);
	}
}

void so_OptimalDesignBlock_ref(so_OptimalDesignBlock *self)
{
	self->reference_count++;
}

void so_OptimalDesignBlock_unref(so_OptimalDesignBlock *self)
{
	if (self) {
		self->reference_count--;
		if (!self->reference_count) {
			so_OptimalDesignBlock_free(self);
		}
	}
}

int *so_OptimalDesignBlock_get_blockNumber(so_OptimalDesignBlock *self)
{
	return self->blockNumber;
}

so_Matrix *so_OptimalDesignBlock_get_FIM(so_OptimalDesignBlock *self)
{
	return self->FIM;
}

so_Matrix *so_OptimalDesignBlock_get_CovarianceMatrix(so_OptimalDesignBlock *self)
{
	return self->CovarianceMatrix;
}

so_Table *so_OptimalDesignBlock_get_ParameterPrecision(so_OptimalDesignBlock *self)
{
	return self->ParameterPrecision;
}

so_Table *so_OptimalDesignBlock_get_Criteria(so_OptimalDesignBlock *self)
{
	return self->Criteria;
}

so_Table *so_OptimalDesignBlock_get_Tests(so_OptimalDesignBlock *self)
{
	return self->Tests;
}

so_ExternalFile *so_OptimalDesignBlock_get_SimulatedData(so_OptimalDesignBlock *self)
{
	return self->SimulatedData;
}

so_ExternalFile *so_OptimalDesignBlock_get_Design(so_OptimalDesignBlock *self)
{
	return self->Design;
}

void so_OptimalDesignBlock_set_blockNumber(so_OptimalDesignBlock *self, int *value)
{
	if (value) {
		self->blockNumber_number = *value;
		self->blockNumber = &(self->blockNumber_number);
	} else {
		self->blockNumber = value;
	}
}

void so_OptimalDesignBlock_set_FIM(so_OptimalDesignBlock *self, so_Matrix *value)
{
	so_Matrix_unref(self->FIM);
	self->FIM = value;
}

void so_OptimalDesignBlock_set_CovarianceMatrix(so_OptimalDesignBlock *self, so_Matrix *value)
{
	so_Matrix_unref(self->CovarianceMatrix);
	self->CovarianceMatrix = value;
}

void so_OptimalDesignBlock_set_ParameterPrecision(so_OptimalDesignBlock *self, so_Table *value)
{
	so_Table_unref(self->ParameterPrecision);
	self->ParameterPrecision = value;
}

void so_OptimalDesignBlock_set_Criteria(so_OptimalDesignBlock *self, so_Table *value)
{
	so_Table_unref(self->Criteria);
	self->Criteria = value;
}

void so_OptimalDesignBlock_set_Tests(so_OptimalDesignBlock *self, so_Table *value)
{
	so_Table_unref(self->Tests);
	self->Tests = value;
}

void so_OptimalDesignBlock_set_SimulatedData(so_OptimalDesignBlock *self, so_ExternalFile *value)
{
	so_ExternalFile_unref(self->SimulatedData);
	self->SimulatedData = value;
}

void so_OptimalDesignBlock_set_Design(so_OptimalDesignBlock *self, so_ExternalFile *value)
{
	so_ExternalFile_unref(self->Design);
	self->Design = value;
}

so_Matrix *so_OptimalDesignBlock_create_FIM(so_OptimalDesignBlock *self)
{
	so_Matrix *obj = so_Matrix_new("FIM");
	if (obj) {
		self->FIM = obj;
	}
	return obj;
}

so_Matrix *so_OptimalDesignBlock_create_CovarianceMatrix(so_OptimalDesignBlock *self)
{
	so_Matrix *obj = so_Matrix_new("CovarianceMatrix");
	if (obj) {
		self->CovarianceMatrix = obj;
	}
	return obj;
}

so_Table *so_OptimalDesignBlock_create_ParameterPrecision(so_OptimalDesignBlock *self)
{
	so_Table *obj = so_Table_new("ParameterPrecision");
	if (obj) {
		self->ParameterPrecision = obj;
	}
	return obj;
}

so_Table *so_OptimalDesignBlock_create_Criteria(so_OptimalDesignBlock *self)
{
	so_Table *obj = so_Table_new("Criteria");
	if (obj) {
		self->Criteria = obj;
	}
	return obj;
}

so_Table *so_OptimalDesignBlock_create_Tests(so_OptimalDesignBlock *self)
{
	so_Table *obj = so_Table_new("Tests");
	if (obj) {
		self->Tests = obj;
	}
	return obj;
}

so_ExternalFile *so_OptimalDesignBlock_create_SimulatedData(so_OptimalDesignBlock *self)
{
	so_ExternalFile *obj = so_ExternalFile_new("SimulatedData");
	if (obj) {
		self->SimulatedData = obj;
	}
	return obj;
}

so_ExternalFile *so_OptimalDesignBlock_create_Design(so_OptimalDesignBlock *self)
{
	so_ExternalFile *obj = so_ExternalFile_new("Design");
	if (obj) {
		self->Design = obj;
	}
	return obj;
}

int so_OptimalDesignBlock_xml(so_OptimalDesignBlock *self, xmlTextWriterPtr writer)
{
	int rc;
	if (self->FIM || self->CovarianceMatrix || self->ParameterPrecision || self->Criteria || self->Tests || self->SimulatedData || self->Design || self->blockNumber) {
		rc = xmlTextWriterStartElement(writer, BAD_CAST "OptimalDesignBlock");
		if (rc < 0) return 1;
		if (self->blockNumber) {
			char *attr_string = pharmml_int_to_string(self->blockNumber_number);
			if (!attr_string) return 1;
			rc = xmlTextWriterWriteAttribute(writer, BAD_CAST "blockNumber", BAD_CAST attr_string);
			free(attr_string);
			if (rc < 0) return 1;
		}
		if (self->FIM) {
			rc = so_Matrix_xml(self->FIM, writer, "FIM");
			if (rc != 0) return rc;
		}
		if (self->CovarianceMatrix) {
			rc = so_Matrix_xml(self->CovarianceMatrix, writer, "CovarianceMatrix");
			if (rc != 0) return rc;
		}
		if (self->ParameterPrecision) {
			rc = so_Table_xml(self->ParameterPrecision, writer, "ParameterPrecision");
			if (rc != 0) return rc;
		}
		if (self->Criteria) {
			rc = so_Table_xml(self->Criteria, writer, "Criteria");
			if (rc != 0) return rc;
		}
		if (self->Tests) {
			rc = so_Table_xml(self->Tests, writer, "Tests");
			if (rc != 0) return rc;
		}
		if (self->SimulatedData) {
			rc = so_ExternalFile_xml(self->SimulatedData, writer, "SimulatedData");
			if (rc != 0) return rc;
		}
		if (self->Design) {
			rc = so_ExternalFile_xml(self->Design, writer, "Design");
			if (rc != 0) return rc;
		}
		rc = xmlTextWriterEndElement(writer);
		if (rc < 0) return 1;
	}
	return 0;
}

int so_OptimalDesignBlock_start_element(so_OptimalDesignBlock *self, const char *localname, int nb_attributes, const char **attributes)
{
	if (self->in_FIM) {
		int fail = so_Matrix_start_element(self->FIM, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_CovarianceMatrix) {
		int fail = so_Matrix_start_element(self->CovarianceMatrix, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_ParameterPrecision) {
		int fail = so_Table_start_element(self->ParameterPrecision, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_Criteria) {
		int fail = so_Table_start_element(self->Criteria, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_Tests) {
		int fail = so_Table_start_element(self->Tests, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_SimulatedData) {
		int fail = so_ExternalFile_start_element(self->SimulatedData, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (self->in_Design) {
		int fail = so_ExternalFile_start_element(self->Design, localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (strcmp(localname, "FIM") == 0) {
		so_Matrix *FIM = so_OptimalDesignBlock_create_FIM(self);
		if (!FIM) {
			return 1;
		}
		self->in_FIM = 1;
	} else if (strcmp(localname, "CovarianceMatrix") == 0) {
		so_Matrix *CovarianceMatrix = so_OptimalDesignBlock_create_CovarianceMatrix(self);
		if (!CovarianceMatrix) {
			return 1;
		}
		self->in_CovarianceMatrix = 1;
	} else if (strcmp(localname, "ParameterPrecision") == 0) {
		so_Table *ParameterPrecision = so_OptimalDesignBlock_create_ParameterPrecision(self);
		if (!ParameterPrecision) {
			return 1;
		}
		self->in_ParameterPrecision = 1;
	} else if (strcmp(localname, "Criteria") == 0) {
		so_Table *Criteria = so_OptimalDesignBlock_create_Criteria(self);
		if (!Criteria) {
			return 1;
		}
		self->in_Criteria = 1;
	} else if (strcmp(localname, "Tests") == 0) {
		so_Table *Tests = so_OptimalDesignBlock_create_Tests(self);
		if (!Tests) {
			return 1;
		}
		self->in_Tests = 1;
	} else if (strcmp(localname, "SimulatedData") == 0) {
		so_ExternalFile *SimulatedData = so_ExternalFile_new("SimulatedData");
		if (!SimulatedData) {
			return 1;
		}
		int fail = so_ExternalFile_init_attributes(SimulatedData, nb_attributes, attributes);
		if (fail) {
			so_ExternalFile_free(SimulatedData);
			return 1;
		}
		so_OptimalDesignBlock_set_SimulatedData(self, SimulatedData);
		self->in_SimulatedData = 1;
	} else if (strcmp(localname, "Design") == 0) {
		so_ExternalFile *Design = so_ExternalFile_new("Design");
		if (!Design) {
			return 1;
		}
		int fail = so_ExternalFile_init_attributes(Design, nb_attributes, attributes);
		if (fail) {
			so_ExternalFile_free(Design);
			return 1;
		}
		so_OptimalDesignBlock_set_Design(self, Design);
		self->in_Design = 1;
	}
	return 0;
}

void so_OptimalDesignBlock_end_element(so_OptimalDesignBlock *self, const char *localname)
{
	if (strcmp(localname, "FIM") == 0 && self->in_FIM) {
		self->in_FIM = 0;
	} else if (strcmp(localname, "CovarianceMatrix") == 0 && self->in_CovarianceMatrix) {
		self->in_CovarianceMatrix = 0;
	} else if (strcmp(localname, "ParameterPrecision") == 0 && self->in_ParameterPrecision) {
		self->in_ParameterPrecision = 0;
	} else if (strcmp(localname, "Criteria") == 0 && self->in_Criteria) {
		self->in_Criteria = 0;
	} else if (strcmp(localname, "Tests") == 0 && self->in_Tests) {
		self->in_Tests = 0;
	} else if (strcmp(localname, "SimulatedData") == 0 && self->in_SimulatedData) {
		self->in_SimulatedData = 0;
	} else if (strcmp(localname, "Design") == 0 && self->in_Design) {
		self->in_Design = 0;
	} else if (self->in_FIM) {
		so_Matrix_end_element(self->FIM, localname);
	} else if (self->in_CovarianceMatrix) {
		so_Matrix_end_element(self->CovarianceMatrix, localname);
	} else if (self->in_ParameterPrecision) {
		so_Table_end_element(self->ParameterPrecision, localname);
	} else if (self->in_Criteria) {
		so_Table_end_element(self->Criteria, localname);
	} else if (self->in_Tests) {
		so_Table_end_element(self->Tests, localname);
	} else if (self->in_SimulatedData) {
		so_ExternalFile_end_element(self->SimulatedData, localname);
	} else if (self->in_Design) {
		so_ExternalFile_end_element(self->Design, localname);
	}
}

int so_OptimalDesignBlock_characters(so_OptimalDesignBlock *self, const char *ch, int len)
{
	if (self->in_FIM) {
		int fail = so_Matrix_characters(self->FIM, ch, len);
		if (fail) return 1;
	} else if (self->in_CovarianceMatrix) {
		int fail = so_Matrix_characters(self->CovarianceMatrix, ch, len);
		if (fail) return 1;
	} else if (self->in_ParameterPrecision) {
		int fail = so_Table_characters(self->ParameterPrecision, ch, len);
		if (fail) return 1;
	} else if (self->in_Criteria) {
		int fail = so_Table_characters(self->Criteria, ch, len);
		if (fail) return 1;
	} else if (self->in_Tests) {
		int fail = so_Table_characters(self->Tests, ch, len);
		if (fail) return 1;
	} else if (self->in_SimulatedData) {
		int fail = so_ExternalFile_characters(self->SimulatedData, ch, len);
		if (fail) return 1;
	} else if (self->in_Design) {
		int fail = so_ExternalFile_characters(self->Design, ch, len);
		if (fail) return 1;
	}
	return 0;
}

int so_OptimalDesignBlock_init_attributes(so_OptimalDesignBlock *self, int nb_attributes, const char **attributes)
{
	unsigned int index = 0;
	for (int i = 0; i < nb_attributes; i++, index += 5) {
		const char *localname = attributes[index];
		const char *valueBegin = attributes[index + 3];
		const char *valueEnd = attributes[index + 4];

		if (strcmp(localname, "blockNumber") == 0) {
			char *final_char = (char *) valueEnd;
			char end_char = *final_char;
			*final_char = '\0';
			self->blockNumber_number = pharmml_string_to_int(valueBegin);
			self->blockNumber = &(self->blockNumber_number);
			*final_char = end_char;
		}
	}
	return 0;
}
