/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#ifndef _SO_TASKINFORMATION_H
#define _SO_TASKINFORMATION_H

#include <so/Message.h>
#include <so/ExternalFile.h>

/** \struct so_TaskInformation
	 \brief A structure representing an SO/SOBlock/TaskInformation element
*/
typedef struct so_TaskInformation so_TaskInformation;

/** \memberof so_TaskInformation
 * Create a new empty so_TaskInformation structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_TaskInformation_copy, so_TaskInformation_free
 */
so_TaskInformation *so_TaskInformation_new();
/** \memberof so_TaskInformation
 * Create a copy of a so_TaskInformation structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_TaskInformation_new
 */
so_TaskInformation *so_TaskInformation_copy(so_TaskInformation *self);
/** \memberof so_TaskInformation
 * Free all memory associated with a so_TaskInformation structure and its children.
 * \param self - a pointer to the structure to free
 * \sa so_TaskInformation_new
 */
void so_TaskInformation_free(so_TaskInformation *self);
void so_TaskInformation_ref(so_TaskInformation *self);
void so_TaskInformation_unref(so_TaskInformation *self);
/** \memberof so_TaskInformation
 * Get the Message element
 * \param self - pointer to a so_TaskInformation
 * \param number - An index to the specific element
 * \return A pointer to the structure representing the Message element
 * \sa so_TaskInformation_set_Message
 */
so_Message *so_TaskInformation_get_Message(so_TaskInformation *self, int number);
/** \memberof so_TaskInformation
 * Get the number of Message currently contained in the TaskInformation structure
 * \param self - pointer to a so_TaskInformation
 * \return The number of Messages
 */
int so_TaskInformation_get_number_of_Message(so_TaskInformation *self);
/** \memberof so_TaskInformation
 * Get the OutputFilePath element
 * \param self - pointer to a so_TaskInformation
 * \param number - An index to the specific element
 * \return A pointer to the structure representing the OutputFilePath element
 * \sa so_TaskInformation_set_OutputFilePath
 */
so_ExternalFile *so_TaskInformation_get_OutputFilePath(so_TaskInformation *self, int number);
/** \memberof so_TaskInformation
 * Get the number of OutputFilePath currently contained in the TaskInformation structure
 * \param self - pointer to a so_TaskInformation
 * \return The number of OutputFilePaths
 */
int so_TaskInformation_get_number_of_OutputFilePath(so_TaskInformation *self);
/** \memberof so_TaskInformation
 * Get the RunTime element
 * \param self - pointer to a so_TaskInformation
 * \return A pointer to the value of RunTime or NULL if no value is present.
 * \sa so_TaskInformation_set_RunTime
 */
double *so_TaskInformation_get_RunTime(so_TaskInformation *self);
/** \memberof so_TaskInformation
 * Get the NumberChains element
 * \param self - pointer to a so_TaskInformation
 * \return A pointer to the value of NumberChains or NULL if no value is present.
 * \sa so_TaskInformation_set_NumberChains
 */
int *so_TaskInformation_get_NumberChains(so_TaskInformation *self);
/** \memberof so_TaskInformation
 * Get the NumberIterations element
 * \param self - pointer to a so_TaskInformation
 * \return A pointer to the value of NumberIterations or NULL if no value is present.
 * \sa so_TaskInformation_set_NumberIterations
 */
int *so_TaskInformation_get_NumberIterations(so_TaskInformation *self);
/** \memberof so_TaskInformation
 * Set the RunTime element
 * \param self - pointer to a so_TaskInformation
 * \param value - A pointer to the value to set or NULL to not include this element.
 * \sa so_TaskInformation_get_RunTime
 */
void so_TaskInformation_set_RunTime(so_TaskInformation *self, double *value);
/** \memberof so_TaskInformation
 * Set the NumberChains element
 * \param self - pointer to a so_TaskInformation
 * \param value - A pointer to the value to set or NULL to not include this element.
 * \sa so_TaskInformation_get_NumberChains
 */
void so_TaskInformation_set_NumberChains(so_TaskInformation *self, int *value);
/** \memberof so_TaskInformation
 * Set the NumberIterations element
 * \param self - pointer to a so_TaskInformation
 * \param value - A pointer to the value to set or NULL to not include this element.
 * \sa so_TaskInformation_get_NumberIterations
 */
void so_TaskInformation_set_NumberIterations(so_TaskInformation *self, int *value);
/** \memberof so_TaskInformation
 * Create a new Message element and insert it into the so_TaskInformation
 * \param self - pointer to a so_TaskInformation
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_Message *so_TaskInformation_create_Message(so_TaskInformation *self);
int so_TaskInformation_add_Message(so_TaskInformation *self, so_Message *child);
int so_TaskInformation_remove_Message(so_TaskInformation *self, int index);
/** \memberof so_TaskInformation
 * Create a new OutputFilePath element and insert it into the so_TaskInformation
 * \param self - pointer to a so_TaskInformation
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_ExternalFile *so_TaskInformation_create_OutputFilePath(so_TaskInformation *self);
int so_TaskInformation_add_OutputFilePath(so_TaskInformation *self, so_ExternalFile *child);
int so_TaskInformation_remove_OutputFilePath(so_TaskInformation *self, int index);

#endif
