% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licoread.R
\name{licoread}
\alias{licoread}
\title{reads Li-COR files in a given location}
\usage{
licoread(
  location,
  file_type = "auto",
  file_type_list = c("82z", "81x", "auto"),
  data_file = "data.csv",
  meta_file = "metadata.json",
  regex_file = "(\\\\w*-)*\\\\w*(?=([.]82z$))",
  sample = FALSE
)
}
\arguments{
\item{location}{location of the files}

\item{file_type}{type of file (82z or 81x). If "auto" (default), the
function will try to detect it by itself.}

\item{file_type_list}{list of file types}

\item{data_file}{name of the file with raw data}

\item{meta_file}{name of the file with meta data}

\item{regex_file}{regex expression matching the name of the 82z file. Here
in case the user has a different than the default and for easier updates.}

\item{sample}{\code{sample = n} randomly selects n files to be imported.
This allows for testing the setup before importing a potentially large list
of files which will take time and be difficult to handle.}
}
\value{
a tibble (nested or not depending on raw data) containing all the
data from the raw files present at the location provided
}
\description{
reads Li-COR files in a given location
}
\examples{
path_82z <- system.file("extdata/82z", package = "licoread")
licoread(path_82z)
}
