% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasnormalize.r
\name{lasnormalize}
\alias{lasnormalize}
\title{Subtract digital terrain model}
\usage{
lasnormalize(.las, dtm = NULL, ...)
}
\arguments{
\item{.las}{a LAS objet}

\item{dtm}{a RasterLayer object from package \link[raster:raster]{raster}. If NULL the function will
automatically compute it on the fly using the function \link[lidR:grid_terrain]{grid_terrain}.}

\item{...}{optional parameters for \link[lidR:grid_terrain]{grid_terrain} if
\code{dtm} parameter is NULL.}
}
\value{
A LAS object.
}
\description{
Subtract digital terrain model (DTM) from the LiDAR data to create a dataset
normalized with the ground at 0. The digital terrain model can originate from
several sources e.g. from an external file or computed by the user. It can also be computed on the
fly.
}
\examples{
LASfile <- system.file("extdata", "Topography.laz", package="lidR")
lidar = readLAS(LASfile)

plot(lidar)

# --- First possibility: compute the DTM on the fly -----

lidar_norm = lasnormalize(lidar, method = "knnidw")

plot(lidar_norm)

\dontrun{
# --- Second possibility: read the DTM from a file -----

dtm = raster::raster(terrain.tiff)

lidar_norm = lidar - dtm # is synonymous with lasnormalize(lidar, dtm)

plot(lidar_norm)
}
}
\seealso{
\link[raster:raster]{raster}
\link[lidR:grid_terrain]{grid_terrain}
}

