% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize_height.R
\name{normalize_height}
\alias{normalize_height}
\alias{unnormalize_height}
\alias{-,LAS,RasterLayer-method}
\alias{-,LAS,lidRAlgorithm-method}
\title{Remove the topography from a point cloud}
\usage{
normalize_height(
  las,
  algorithm,
  na.rm = FALSE,
  use_class = c(2L, 9L),
  ...,
  add_lasattribute = FALSE,
  Wdegenerated = TRUE
)

unnormalize_height(las)

\S4method{-}{LAS,RasterLayer}(e1, e2)

\S4method{-}{LAS,lidRAlgorithm}(e1, e2)
}
\arguments{
\item{las}{An object of class \link[lidR:LAS-class]{LAS} or \link[lidR:LAScatalog-class]{LAScatalog}.}

\item{algorithm}{a spatial interpolation function. \code{lidR} have \link{tin},
\link{kriging}, \link{knnidw} or a \link[raster:raster]{RasterLayer} representing a digital terrain
model (can be computed with \link{grid_terrain})}

\item{na.rm}{logical. When using a \code{RasterLayer} as DTM, by default the function fails if a point
fall in an empty pixel because a Z elevation cannot be NA. If \code{na.rm = TRUE} points with an
elevation of NA are filtered. Be careful this creates a copy of the point cloud.}

\item{use_class}{integer vector. By default the terrain is computed by using ground points
(class 2) and water points (class 9). Relevant only for a normalisation without a raster DTM.}

\item{...}{If \code{algorithm} is a \code{RasterLayer}, \code{...} is propagated to
\link[raster:extract]{extract}. Typically one may use \code{method = "bilinear"}.}

\item{add_lasattribute}{logical. By default the above see level elevation is retained in a new attribute.
However this new attribute will be discared at write time. If \code{TRUE} it is maintained as an
extrabytes attribute. See also \link{add_lasattribute}.}

\item{Wdegenerated}{logical. The function always check and remove degenerated ground points
for computing the DTM to avoid unexpected behaviours such as infinite elevation. If
TRUE a warning in thrown to alert about the presence of degenerated ground points.}

\item{e1}{a LAS object}

\item{e2}{\link[raster:raster]{RasterLayer} representing a digital terrain model (can be
computed with \link{grid_terrain}) or a spatial interpolation function. \code{lidR} has \link{tin},
\link{kriging}, and \link{knnidw}.}
}
\value{
If the input is a \code{LAS} object, return a \code{LAS} object. If the input is a
\code{LAScatalog}, returns a \code{LAScatalog}.
}
\description{
Subtract digital terrain model (DTM) from LiDAR point cloud to create a dataset normalized with
the ground at 0. The DTM can originate from an external file or can be computed by the user. It can
also be computed on-the-fly. In this case the algorithm does not use rasterized data and each point
is interpolated. There is no inaccuracy due to the discretization of the terrain and the resolution
of the terrain is virtually infinite.\cr\cr
How well the edges of the dataset are interpolated depends on the interpolation method used.
Thus, a buffer around the region of interest is always recommended to avoid edge effects.\cr\cr
The attribute Z of the returned LAS object is the normalized elevation. A new attribute 'Zref'
records the former elevation values, which enables the use of \link{unnormalize_height} to restore
original point elevations.\cr\cr
}
\section{Working with a \code{LAScatalog}}{

This section appears in each function that supports a LAScatalog as input.\cr

In \code{lidR} when the input of a function is a \link[lidR:LAScatalog-class]{LAScatalog} the
function uses the LAScatalog processing engine. The user can modify the engine options using
the \link[lidR:catalog_options_tools]{available options}. A careful reading of the
\link[lidR:LAScatalog-class]{engine documentation} is recommended before processing \code{LAScatalogs}. Each
\code{lidR} function should come with a section that documents the supported engine options.\cr

The \code{LAScatalog} engine supports \code{.lax} files that \emph{significantly} improve the computation
speed of spatial queries using a spatial index. Users should really take advantage a \code{.lax} files,
but this is not mandatory.\cr
}

\section{Supported processing options}{

Supported processing options for a \code{LAScatalog} (in bold). For more details see the
\link[lidR:LAScatalog-class]{LAScatalog engine documentation}:
\itemize{
\item \strong{chunk size}: How much data is loaded at once.
\item \strong{chunk buffer*}: Mandatory to get a continuous output without edge effects. The buffer
is always removed once processed and will never be returned either in R or in files.
\item \strong{chunk alignment}: Align the processed chunks.
\item \strong{progress}: Displays a progression estimation.
\item \strong{output files*}: Mandatory because the output is likely to be too big to be returned
in R and needs to be written in las/laz files. Supported templates are \code{\{XLEFT\}}, \code{\{XRIGHT\}},
\code{\{YBOTTOM\}}, \code{\{YTOP\}}, \code{\{XCENTER\}}, \code{\{YCENTER\}} \code{\{ID\}} and, if
chunk size is equal to 0 (processing by file), \code{\{ORIGINALFILENAME\}}.
\item select: The function will write files equivalent to the original ones. Thus \code{select = "*"}
and cannot be changed.
\item \strong{filter}: Read only points of interest.
}
}

\examples{
LASfile <- system.file("extdata", "Topography.laz", package="lidR")
las <- readLAS(LASfile, filter = "-inside 273450 5274350 273550 5274450")

#plot(las)

# First option: use a RasterLayer as DTM
# =======================================================

dtm <- grid_terrain(las, 1, knnidw(k = 6L, p = 2))
las <- normalize_height(las, dtm)

plot(dtm)
#plot(las)

# restore original elevations
las <- unnormalize_height(las)
#plot(las)

# operator - can be used. This is equivalent to the previous
las <- las - dtm
#plot(las)

# restore original elevations
las <- unnormalize_height(las)

# Second option: interpolate each point (no discretization)
# =========================================================

las <- normalize_height(las, tin())
#plot(las)

# operator - can be used. This is equivalent to the previous
las <- unnormalize_height(las)
las <- las - tin()

\dontrun{
# All the following syntaxes are correct
las <- normalize_height(las, knnidw())
las <- normalize_height(las, knnidw(k = 8, p = 2))
las <- las - knnidw()
las <- las - knnidw(k = 8)
las <- normalize_height(las, kriging())
las <- las - kriging(k = 8)
}

}
\seealso{
\link[=grid_terrain]{grid_terrain}

Other normalize: 
\code{\link{normalize_intensity}()}
}
\concept{normalize}
