% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projection.R
\name{projection}
\alias{projection}
\alias{epsg}
\alias{epsg<-}
\alias{epsg,LASheader-method}
\alias{epsg<-,LASheader-method}
\alias{epsg,LAS-method}
\alias{epsg<-,LAS-method}
\alias{wkt<-}
\alias{wkt,LASheader-method}
\alias{wkt<-,LASheader-method}
\alias{wkt,LAS-method}
\alias{wkt<-,LAS-method}
\alias{projection,LASheader-method}
\alias{projection,LAS-method}
\alias{projection<-,LAS-method}
\alias{projection,LAScatalog-method}
\alias{projection<-,LAScatalog-method}
\alias{crs,LASheader-method}
\alias{crs,LAS-method}
\alias{crs<-,LAS-method}
\alias{crs,LAScatalog-method}
\alias{crs<-,LAScatalog-method}
\title{Get or set the projection of a LAS* object}
\usage{
epsg(object, ...)

epsg(object) <- value

\S4method{epsg}{LASheader}(object, ...)

\S4method{epsg}{LASheader}(object) <- value

\S4method{epsg}{LAS}(object)

\S4method{epsg}{LAS}(object) <- value

wkt(object) <- value

\S4method{wkt}{LASheader}(obj)

\S4method{wkt}{LASheader}(object) <- value

\S4method{wkt}{LAS}(obj)

\S4method{wkt}{LAS}(object) <- value

\S4method{projection}{LASheader}(x, asText = TRUE)

\S4method{projection}{LAS}(x, asText = TRUE)

\S4method{projection}{LAS}(x) <- value

\S4method{projection}{LAScatalog}(x, asText = TRUE)

\S4method{projection}{LAScatalog}(x) <- value

\S4method{crs}{LASheader}(x, asText = FALSE)

\S4method{crs}{LAS}(x, asText = FALSE)

\S4method{crs}{LAS}(x, ...) <- value

\S4method{crs}{LAScatalog}(x, asText = FALSE)

\S4method{crs}{LAScatalog}(x, ...) <- value
}
\arguments{
\item{object, x, obj}{An object of class LAS or eventually LASheader (regular users don't need to manipulate
LASheader objects).}

\item{...}{Unused.}

\item{value}{A \code{CRS} object or a \code{proj4string} string or WKT string or an EPSG code.}

\item{asText}{logical. If TRUE, the projection is returned as text. Otherwise a CRS object is returned.}
}
\description{
Get or set the projection of a LAS* object.
}
\details{
There are two ways to store the CRS of a point cloud in a LAS file:
\itemize{
\item Store an EPSG code (for LAS 1.0 to 1.3)
\item Store a WTK string (for LAS 1.4)
}

On the other hand, R sptial packages use a \code{proj4string} to store the CRS (but
the ecosystem is moving to WKT). This is why the CRS is duplicated in a LAS object.
The information belongs within the header in a format that can be written in a
LAS file and in the slot \code{proj4string} in a format that can be understood by R
packages.
\itemize{
\item \verb{projection<-}: assigns a CRS from a \code{CRS} (\code{sp}), a \code{crs} (\code{sf}), a WKT
string, a proj4string or an epsg code. It updates the header of the LAS
object either with the EPSG code for LAS formats < 1.4 or with a WKT string
for LAS format 1.4 and updates the \code{proj4string} slot.
\item \code{projection}: returns the CRS in \code{sp} format
\item \code{crs} and \verb{crs<-} are equivalent to \code{projection} and \verb{projection<-}
\item \verb{epsg<-}, \verb{wkt<- }: legacy functions superseded by \verb{projection<-}
\item \code{sf::st_crs} return the CRS in \code{sf} format.
\item \code{epsg}: reads the epsg code from the header.
\item \code{wkt}: reads the WKT string from the header.
}
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
las <- readLAS(LASfile)

# Get the EPSG code stored in the header (returns 0 if not recorded)
epsg(las)

# Get the WKT string stored in the header (LAS >= 1.4)
wkt(las)

# Overwrite the CRS (but does not reproject)
crs <- sp::CRS("+init=epsg:26918")
projection(las) <- crs
sf::st_crs(las)$input

# Uses the EPSG code
projection(las) <- 26919
sf::st_crs(las)$input

# Uses a crs from sf
crs <- sf::st_crs(3035)
projection(las) <- crs

}
