% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm-dec.R
\name{sample_per_voxel}
\alias{sample_per_voxel}
\alias{random_per_voxel}
\title{Point Cloud Decimation Algorithm}
\usage{
random_per_voxel(res = 1, n = 1)
}
\arguments{
\item{res}{numeric. The resolution of the voxel grid used to filter the point cloud}

\item{n}{integer. The number of points to select}
}
\description{
This functions is made to be used in \link{decimate_points}. It implements an algorithm that
creates a 3D grid with a given resolution and filters the point cloud by randomly selecting
n points within each voxel
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
las <- readLAS(LASfile, select = "xyz")
thinned <- decimate_points(las, random_per_voxel(8, 1))
#plot(thinned)
}
\seealso{
Other point cloud decimation algorithms: 
\code{\link{sample_homogenize}},
\code{\link{sample_maxima}},
\code{\link{sample_random}}
}
\concept{point cloud decimation algorithms}
