% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm-noi.R
\name{range_correction}
\alias{range_correction}
\alias{get_range}
\title{Intensity normalization algorithm}
\usage{
range_correction(sensor, Rs, f = 2.3, gpstime = "gpstime", elevation = "Z")

get_range(las, sensor, gpstime = "gpstime", elevation = "Z")
}
\arguments{
\item{sensor}{`SpatialPointsDataDrame` or `sf` object containing the coordinates of
the sensor at different timepoints t. The time and elevation are stored as attributes
(default names are 'gpstime' and 'Z'). Z can also come from the geometry if the input records XYZ
coordinates. It can be computed with \link{track_sensor}.}

\item{Rs}{numeric. Range of reference.}

\item{f}{numeric. Exponent. Usually between 2 and 3 in vegetation contexts.}

\item{gpstime, elevation}{character. The name of the attributes that store the gpstime of the
position and the elevation of the sensor respectively. If the input contains 3 coordinates points,
`elevation` is not considered.}

\item{las}{an object of class LAS. \code{get_range()} is a regular function documented here for
convenience.}
}
\description{
This function is made to be used in \link{normalize_intensity}. It corrects intensity with a
range correction according to the formula (see references):
\deqn{I_{norm} = I_{obs} \left(\frac{R}{Rs}\right)^f}{Inorm = Iobs * (R/Rs)^f}
To achieve the range correction the position of the sensor must be known at different discrete times.
Using the 'gpstime' of each point, the position of the sensor is interpolated from the reference
and a range correction is applied.
}
\examples{
# A valid file properly populated
LASfile <- system.file("extdata", "Topography.laz", package="lidR")
las <- readLAS(LASfile)

# pmin = 15 because it is an extremely tiny file
# strongly decimated to reduce its size. There are
# actually few multiple returns
sensor <- track_sensor(las, Roussel2020(pmin = 15))

# Here the effect is virtually null because the size of
# the sample is too small to notice any effect of range
las <- normalize_intensity(las, range_correction(sensor, Rs = 2000))

# This might be useful for some applications
R = get_range(las, sensor)
}
\references{
Gatziolis, D. (2011). Dynamic Range-based Intensity Normalization for Airborne, Discrete Return
Lidar Data of Forest Canopies. Photogrammetric Engineering & Remote Sensing, 77(3), 251–259.
https://doi.org/10.14358/pers.77.3.251
}
